/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.config.keys.loader.pem;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.login.CredentialException;
import org.opendaylight.netconf.shaded.sshd.common.NamedResource;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.FilePasswordProvider;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.loader.AbstractKeyPairResourceParser;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.loader.PrivateKeyEncryptionContext;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.loader.PrivateKeyObfuscator;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.loader.pem.KeyPairPEMResourceParser;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionContext;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.MapEntryUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.NumberUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.BufferUtils;

public abstract class AbstractPEMResourceKeyPairParser
extends AbstractKeyPairResourceParser
implements KeyPairPEMResourceParser {
    private final String algo;
    private final String algId;

    protected AbstractPEMResourceKeyPairParser(String algo, String algId, List<String> beginners, List<String> enders) {
        super(beginners, enders);
        this.algo = ValidateUtils.checkNotNullAndNotEmpty(algo, "No encryption algorithm provided");
        this.algId = ValidateUtils.checkNotNullAndNotEmpty(algId, "No algorithm identifier provided");
    }

    @Override
    public String getAlgorithm() {
        return this.algo;
    }

    @Override
    public String getAlgorithmIdentifier() {
        return this.algId;
    }

    @Override
    public Collection<KeyPair> extractKeyPairs(SessionContext session, NamedResource resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, List<String> lines, Map<String, String> headers) throws IOException, GeneralSecurityException {
        if (GenericUtils.isEmpty(lines)) {
            return Collections.emptyList();
        }
        Boolean encrypted = null;
        byte[] initVector = null;
        String algInfo = null;
        int dataStartIndex = -1;
        boolean hdrsAvailable = MapEntryUtils.isNotEmpty(headers);
        for (int index = 0; index < lines.size(); ++index) {
            String line = GenericUtils.trimToEmpty(lines.get(index));
            if (GenericUtils.isEmpty(line)) continue;
            int headerPos = line.indexOf(58);
            if (headerPos < 0) {
                dataStartIndex = index;
                break;
            }
            String hdrName = line.substring(0, headerPos).trim();
            String hdrValue = line.substring(headerPos + 1).trim();
            if (!hdrsAvailable) {
                TreeMap<String, String> accHeaders = MapEntryUtils.isEmpty(headers) ? new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER) : headers;
                accHeaders.put(hdrName, hdrValue);
            }
            if (hdrName.equalsIgnoreCase("Proc-Type")) {
                if (encrypted != null) {
                    throw new StreamCorruptedException("Multiple encryption indicators in " + resourceKey);
                }
                hdrValue = hdrValue.toUpperCase();
                encrypted = line.contains("ENCRYPTED");
                continue;
            }
            if (!hdrName.equalsIgnoreCase("DEK-Info")) continue;
            if (initVector != null || algInfo != null) {
                throw new StreamCorruptedException("Multiple encryption settings in " + resourceKey);
            }
            int infoPos = hdrValue.indexOf(44);
            if (infoPos < 0) {
                throw new StreamCorruptedException(resourceKey + ": Missing encryption data values separator in line '" + line + "'");
            }
            algInfo = hdrValue.substring(0, infoPos).trim();
            String algInitVector = hdrValue.substring(infoPos + 1).trim();
            initVector = BufferUtils.decodeHex('\u0000', algInitVector);
        }
        if (dataStartIndex < 0) {
            throw new StreamCorruptedException("No data lines (only headers or empty) found in " + resourceKey);
        }
        List<String> dataLines = lines.subList(dataStartIndex, lines.size());
        if (encrypted != null || algInfo != null || initVector != null) {
            if (passwordProvider == null) {
                throw new CredentialException("Missing password provider for encrypted resource=" + resourceKey);
            }
            String algorithm = algInfo;
            byte[] iv = initVector;
            byte[] encryptedData = KeyPairResourceParser.extractDataBytes(dataLines);
            Collection keys = passwordProvider.decode(session, resourceKey, password -> {
                PrivateKeyEncryptionContext encContext = new PrivateKeyEncryptionContext(algorithm);
                encContext.setPassword(password);
                encContext.setInitVector(iv);
                byte[] decodedData = GenericUtils.EMPTY_BYTE_ARRAY;
                try {
                    Collection<KeyPair> collection;
                    decodedData = this.applyPrivateKeyCipher(encryptedData, encContext, false);
                    try (ByteArrayInputStream bais = new ByteArrayInputStream(decodedData);){
                        collection = this.extractKeyPairs(session, resourceKey, beginMarker, endMarker, passwordProvider, bais, (Map<String, String>)headers);
                    }
                    return collection;
                }
                finally {
                    Arrays.fill(decodedData, (byte)0);
                }
            });
            return keys == null ? Collections.emptyList() : keys;
        }
        return super.extractKeyPairs(session, resourceKey, beginMarker, endMarker, passwordProvider, dataLines, headers);
    }

    protected byte[] applyPrivateKeyCipher(byte[] bytes, PrivateKeyEncryptionContext encContext, boolean encryptIt) throws GeneralSecurityException, IOException {
        byte[] initVector;
        String cipherName = encContext.getCipherName();
        PrivateKeyObfuscator o = encContext.resolvePrivateKeyObfuscator();
        if (o == null) {
            throw new NoSuchAlgorithmException("decryptPrivateKeyData(" + encContext + ")[encrypt=" + encryptIt + "] unknown cipher: " + cipherName);
        }
        if (encryptIt && NumberUtils.isEmpty(initVector = encContext.getInitVector())) {
            initVector = o.generateInitializationVector(encContext);
            encContext.setInitVector(initVector);
        }
        return o.applyPrivateKeyCipher(bytes, encContext, encryptIt);
    }
}

