/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.config.keys.loader.ssh2;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import org.opendaylight.netconf.shaded.sshd.common.NamedResource;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.KeyEntryResolver;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.KeyTypeNamesSupport;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.KeyUtils;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.PublicKeyEntryResolver;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.PublicKeyRawDataDecoder;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.PublicKeyRawDataReader;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.opendaylight.netconf.shaded.sshd.common.keyprovider.KeyPairProvider;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionContext;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;

public class Ssh2PublicKeyEntryDecoder
implements PublicKeyRawDataDecoder<PublicKey>,
PublicKeyEntryResolver,
PublicKeyRawDataReader<PublicKey>,
KeyTypeNamesSupport {
    public static final NavigableSet<String> SUPPORTED_KEY_TYPES = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, new String[]{"ssh-rsa", "ssh-dss", "ssh-ed25519", KeyPairProvider.ECDSA_SHA2_NISTP256, KeyPairProvider.ECDSA_SHA2_NISTP384, KeyPairProvider.ECDSA_SHA2_NISTP521}));
    public static final String BEGIN_MARKER = "BEGIN SSH2 PUBLIC KEY";
    public static final List<String> START_MARKERS = Collections.singletonList("BEGIN SSH2 PUBLIC KEY");
    public static final String END_MARKER = "END SSH2 PUBLIC KEY";
    public static final List<String> STOP_MARKERS = Collections.singletonList("END SSH2 PUBLIC KEY");
    public static final char HEADER_CONTINUATION_INDICATOR = '\\';
    public static final Ssh2PublicKeyEntryDecoder INSTANCE = new Ssh2PublicKeyEntryDecoder();

    @Override
    public NavigableSet<String> getSupportedKeyTypes() {
        return SUPPORTED_KEY_TYPES;
    }

    @Override
    public PublicKey resolve(SessionContext session, String keyType, byte[] keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
        ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type provided");
        NavigableSet<String> supported = this.getSupportedKeyTypes();
        if (GenericUtils.size(supported) > 0 && supported.contains(keyType)) {
            return this.decodePublicKey(session, keyType, keyData, headers);
        }
        throw new InvalidKeySpecException("resolve(" + keyType + ") not in listed supported types: " + supported);
    }

    @Override
    public PublicKey decodePublicKey(SessionContext session, String keyType, InputStream keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
        return this.decodePublicKeyByType(session, keyType, keyData, headers);
    }

    @Override
    public PublicKey decodePublicKeyByType(SessionContext session, String keyType, InputStream keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
        PublicKeyEntryDecoder<?, ?> decoder = KeyUtils.getPublicKeyEntryDecoder(keyType);
        if (decoder == null) {
            throw new InvalidKeySpecException("No decoder for key type=" + keyType);
        }
        return decoder.decodePublicKeyByType(session, keyType, keyData, headers);
    }

    @Override
    public PublicKey readPublicKey(SessionContext session, NamedResource resourceKey, List<String> lines) throws IOException, GeneralSecurityException {
        AbstractMap.SimpleImmutableEntry<Integer, Integer> markerPos = KeyPairResourceParser.findMarkerLine(lines, START_MARKERS);
        if (markerPos == null) {
            return null;
        }
        int startIndex = (Integer)markerPos.getKey();
        String startLine = lines.get(startIndex);
        if ((markerPos = KeyPairResourceParser.findMarkerLine(lines, ++startIndex, STOP_MARKERS)) == null) {
            throw new StreamCorruptedException("Missing end marker (END SSH2 PUBLIC KEY) after line #" + startIndex);
        }
        int endIndex = (Integer)markerPos.getKey();
        String endLine = lines.get(endIndex);
        Map.Entry<Map<String, String>, List<String>> result = this.separateDataLinesFromHeaders(session, resourceKey, startLine, endLine, lines.subList(startIndex, endIndex));
        Map<String, String> headers = result.getKey();
        List<String> dataLines = result.getValue();
        return this.readPublicKey(session, resourceKey, BEGIN_MARKER, END_MARKER, dataLines == null ? Collections.emptyList() : dataLines, headers == null ? Collections.emptyMap() : headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicKey readPublicKey(SessionContext session, NamedResource resourceKey, String beginMarker, String endMarker, List<String> lines, Map<String, String> headers) throws IOException, GeneralSecurityException {
        byte[] dataBytes = KeyPairResourceParser.extractDataBytes(lines);
        try {
            PublicKey publicKey = this.readPublicKey(session, resourceKey, beginMarker, endMarker, dataBytes, headers);
            return publicKey;
        }
        finally {
            Arrays.fill(dataBytes, (byte)0);
        }
    }

    public PublicKey readPublicKey(SessionContext session, NamedResource resourceKey, String beginMarker, String endMarker, byte[] dataBytes, Map<String, String> headers) throws IOException, GeneralSecurityException {
        Map.Entry<String, Integer> result = KeyEntryResolver.decodeString(dataBytes, 256);
        String keyType = result.getKey();
        return this.resolve(session, keyType, dataBytes, headers);
    }

    protected Map.Entry<Map<String, String>, List<String>> separateDataLinesFromHeaders(SessionContext session, NamedResource resourceKey, String startLine, String endLine, List<String> lines) throws IOException, GeneralSecurityException {
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        int len = lines.size();
        for (int index = 0; index < len; ++index) {
            int vLen;
            String l = lines.get(index);
            if ((l = l.trim()).isEmpty()) continue;
            int pos = l.indexOf(58);
            if (pos < 0) {
                return new AbstractMap.SimpleImmutableEntry<Map<String, String>, List<String>>(headers, lines.subList(index, len));
            }
            String name = l.substring(0, pos).trim();
            String value = l.substring(pos + 1).trim();
            if (value.charAt((vLen = value.length()) - 1) == '\\') {
                value = value.substring(0, vLen - 1);
                ++index;
                while (index < len) {
                    l = lines.get(index);
                    if (l.charAt((vLen = l.length()) - 1) != '\\') {
                        value = value + l;
                        break;
                    }
                    value = value + l.substring(0, vLen - 1);
                    ++index;
                }
            }
            headers.put(name, value.trim());
        }
        throw new StreamCorruptedException("No viable data lines found in " + resourceKey.getName() + " after " + startLine);
    }
}

