/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.config.keys.writer.openssh;

import org.opendaylight.netconf.shaded.sshd.common.config.keys.loader.PrivateKeyEncryptionContext;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;

public class OpenSSHKeyEncryptionContext
extends PrivateKeyEncryptionContext {
    public static final int DEFAULT_KDF_ROUNDS = 16;
    public static final String AES = "AES";
    private int kdfRounds = 16;

    public OpenSSHKeyEncryptionContext() {
        this.setCipherMode("CTR");
    }

    @Override
    public String getCipherName() {
        return AES;
    }

    @Override
    public void setCipherName(String value) {
        ValidateUtils.checkTrue(value != null && value.equalsIgnoreCase(AES), "OpenSSHKeyEncryptionContext works only with AES encryption");
    }

    public int getKdfRounds() {
        return this.kdfRounds;
    }

    public void setKdfRounds(int rounds) {
        this.kdfRounds = Math.max(16, rounds);
    }

    protected String getCipherFactoryName() {
        return this.getCipherName().toLowerCase() + this.getCipherType() + '-' + this.getCipherMode().toLowerCase();
    }
}

