/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.file.root;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;

public final class RootedFileSystemUtils {
    private RootedFileSystemUtils() {
    }

    public static void validateSafeRelativeSymlink(Path target) {
        int numNames = 0;
        int numCdUps = 0;
        for (int i = 0; i < target.getNameCount(); ++i) {
            if ("..".equals(target.getName(i).toString())) {
                ++numCdUps;
            } else if (!".".equals(target.getName(i).toString())) {
                ++numNames;
            }
            if (numCdUps <= numNames) continue;
            throw new InvalidPathException(target.toString(), "Symlink would exit chroot: " + target);
        }
    }
}

