/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.forward;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.opendaylight.netconf.shaded.sshd.client.channel.ClientChannelEvent;
import org.opendaylight.netconf.shaded.sshd.common.Closeable;
import org.opendaylight.netconf.shaded.sshd.common.Factory;
import org.opendaylight.netconf.shaded.sshd.common.FactoryManager;
import org.opendaylight.netconf.shaded.sshd.common.RuntimeSshException;
import org.opendaylight.netconf.shaded.sshd.common.SshException;
import org.opendaylight.netconf.shaded.sshd.common.channel.StreamingChannel;
import org.opendaylight.netconf.shaded.sshd.common.forward.Forwarder;
import org.opendaylight.netconf.shaded.sshd.common.forward.LocalForwardingEntry;
import org.opendaylight.netconf.shaded.sshd.common.forward.PortForwardingEventListener;
import org.opendaylight.netconf.shaded.sshd.common.forward.PortForwardingEventListenerManager;
import org.opendaylight.netconf.shaded.sshd.common.forward.PortForwardingEventListenerManagerHolder;
import org.opendaylight.netconf.shaded.sshd.common.forward.SocksProxy;
import org.opendaylight.netconf.shaded.sshd.common.forward.TcpipClientChannel;
import org.opendaylight.netconf.shaded.sshd.common.forward.TcpipForwardingExceptionMarker;
import org.opendaylight.netconf.shaded.sshd.common.io.IoAcceptor;
import org.opendaylight.netconf.shaded.sshd.common.io.IoHandler;
import org.opendaylight.netconf.shaded.sshd.common.io.IoHandlerFactory;
import org.opendaylight.netconf.shaded.sshd.common.io.IoServiceFactory;
import org.opendaylight.netconf.shaded.sshd.common.io.IoSession;
import org.opendaylight.netconf.shaded.sshd.common.session.ConnectionService;
import org.opendaylight.netconf.shaded.sshd.common.session.Session;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionHolder;
import org.opendaylight.netconf.shaded.sshd.common.util.EventListenerUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ExceptionUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.Readable;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.ByteArrayBuffer;
import org.opendaylight.netconf.shaded.sshd.common.util.closeable.AbstractInnerCloseable;
import org.opendaylight.netconf.shaded.sshd.common.util.io.functors.Invoker;
import org.opendaylight.netconf.shaded.sshd.common.util.net.SshdSocketAddress;
import org.opendaylight.netconf.shaded.sshd.common.util.threads.ThreadUtils;
import org.opendaylight.netconf.shaded.sshd.core.CoreModuleProperties;
import org.opendaylight.netconf.shaded.sshd.server.forward.TcpForwardingFilter;

public class DefaultForwarder
extends AbstractInnerCloseable
implements Forwarder,
SessionHolder<Session> {
    public static final Set<ClientChannelEvent> STATIC_IO_MSG_RECEIVED_EVENTS = Collections.unmodifiableSet(EnumSet.of(ClientChannelEvent.OPENED, ClientChannelEvent.CLOSED));
    private final ConnectionService service;
    private final IoHandlerFactory socksProxyIoHandlerFactory = () -> new SocksProxy(this.getConnectionService());
    private final Session sessionInstance;
    private final Object localLock = new Object();
    private final Map<SshdSocketAddress, SshdSocketAddress> localToRemote = new HashMap<SshdSocketAddress, SshdSocketAddress>();
    private final Map<SshdSocketAddress, InetSocketAddress> boundLocals = new HashMap<SshdSocketAddress, InetSocketAddress>();
    private final Object dynamicLock = new Object();
    private final Map<Integer, SshdSocketAddress> remoteToLocal = new HashMap<Integer, SshdSocketAddress>();
    private final Map<Integer, SocksProxy> dynamicLocal = new HashMap<Integer, SocksProxy>();
    private final Map<Integer, InetSocketAddress> boundDynamic = new HashMap<Integer, InetSocketAddress>();
    private final Set<LocalForwardingEntry> localForwards = new HashSet<LocalForwardingEntry>();
    private final IoHandlerFactory staticIoHandlerFactory = () -> new StaticIoHandler();
    private final Collection<PortForwardingEventListener> listeners = new CopyOnWriteArraySet<PortForwardingEventListener>();
    private final Collection<PortForwardingEventListenerManager> managersHolder = new CopyOnWriteArraySet<PortForwardingEventListenerManager>();
    private final PortForwardingEventListener listenerProxy;
    private IoAcceptor localAcceptor;
    private IoAcceptor dynamicAcceptor;

    public DefaultForwarder(ConnectionService service) {
        this.service = Objects.requireNonNull(service, "No connection service");
        this.sessionInstance = (Session)Objects.requireNonNull(service.getSession(), "No session");
        this.listenerProxy = EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.listeners);
    }

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.listenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener listener) {
        this.listeners.add(PortForwardingEventListener.validateListener(listener));
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(PortForwardingEventListener.validateListener(listener));
    }

    @Override
    public Collection<PortForwardingEventListenerManager> getRegisteredManagers() {
        return this.managersHolder.isEmpty() ? Collections.emptyList() : new ArrayList<PortForwardingEventListenerManager>(this.managersHolder);
    }

    @Override
    public boolean addPortForwardingEventListenerManager(PortForwardingEventListenerManager manager) {
        return this.managersHolder.add(Objects.requireNonNull(manager, "No manager"));
    }

    @Override
    public boolean removePortForwardingEventListenerManager(PortForwardingEventListenerManager manager) {
        if (manager == null) {
            return false;
        }
        return this.managersHolder.remove(manager);
    }

    @Override
    public Session getSession() {
        return this.sessionInstance;
    }

    public final ConnectionService getConnectionService() {
        return this.service;
    }

    protected Collection<PortForwardingEventListener> getDefaultListeners() {
        ArrayList<PortForwardingEventListener> defaultListeners = new ArrayList<PortForwardingEventListener>();
        defaultListeners.add(this.getPortForwardingEventListenerProxy());
        Session session = this.getSession();
        PortForwardingEventListener l = session.getPortForwardingEventListenerProxy();
        if (l != null) {
            defaultListeners.add(l);
        }
        FactoryManager manager = session == null ? null : session.getFactoryManager();
        PortForwardingEventListener portForwardingEventListener = l = manager == null ? null : manager.getPortForwardingEventListenerProxy();
        if (l != null) {
            defaultListeners.add(l);
        }
        return defaultListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startLocalPortForwarding(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        SshdSocketAddress result;
        Objects.requireNonNull(local, "Local address is null");
        ValidateUtils.checkTrue(local.getPort() >= 0, "Invalid local port: %s", (Object)local);
        Objects.requireNonNull(remote, "Remote address is null");
        if (this.isClosed() || this.isClosing()) {
            throw new IllegalStateException("TcpipForwarder is closed or closing: " + this.state);
        }
        this.signalEstablishingExplicitTunnel(local, remote, true);
        InetSocketAddress bound = null;
        try {
            bound = this.doBind(local, this.getLocalIoAcceptor());
            int port = bound.getPort();
            result = new SshdSocketAddress(bound.getHostString(), port);
            Object object = this.localLock;
            synchronized (object) {
                SshdSocketAddress prevRemote = SshdSocketAddress.findByOptionalWildcardAddress(this.localToRemote, result);
                if (prevRemote != null) {
                    throw new IOException("Multiple local port forwarding addressing on port=" + result + ": current=" + remote + ", previous=" + prevRemote);
                }
                InetSocketAddress prevBound = SshdSocketAddress.findByOptionalWildcardAddress(this.boundLocals, result);
                if (prevBound != null) {
                    throw new IOException("Multiple local port forwarding bindings on port=" + result + ": current=" + bound + ", previous=" + prevBound);
                }
                this.localToRemote.put(result, remote);
                this.boundLocals.put(result, bound);
            }
        }
        catch (IOException | RuntimeException e) {
            try {
                this.unbindLocalForwarding(local, remote, bound);
            }
            catch (IOException | RuntimeException err) {
                e.addSuppressed(err);
            }
            this.signalEstablishedExplicitTunnel(local, remote, true, null, e);
            throw e;
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("startLocalPortForwarding({} -> {}): {}", new Object[]{local, remote, result});
            }
            this.signalEstablishedExplicitTunnel(local, remote, true, result, null);
            return result;
        }
        catch (IOException | RuntimeException e) {
            this.stopLocalPortForwarding(local);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopLocalPortForwarding(SshdSocketAddress local) throws IOException {
        InetSocketAddress bound;
        SshdSocketAddress remote;
        Objects.requireNonNull(local, "Local address is null");
        Object object = this.localLock;
        synchronized (object) {
            remote = SshdSocketAddress.removeByOptionalWildcardAddress(this.localToRemote, local);
            bound = SshdSocketAddress.removeByOptionalWildcardAddress(this.boundLocals, local);
        }
        this.unbindLocalForwarding(local, remote, bound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindLocalForwarding(SshdSocketAddress local, SshdSocketAddress remote, InetSocketAddress bound) throws IOException {
        if (bound != null && this.localAcceptor != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("unbindLocalForwarding({} => {}) unbind {}", new Object[]{local, remote, bound});
            }
            SshdSocketAddress boundAddress = new SshdSocketAddress(bound);
            try {
                this.signalTearingDownExplicitTunnel(boundAddress, true, remote);
            }
            finally {
                try {
                    this.localAcceptor.unbind(bound);
                }
                catch (RuntimeException e) {
                    this.signalTornDownExplicitTunnel(boundAddress, true, remote, e);
                    throw e;
                }
            }
            this.signalTornDownExplicitTunnel(boundAddress, true, remote, null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("unbindLocalForwarding({} => {}) no mapping({}) or acceptor({})", new Object[]{local, remote, bound, this.localAcceptor});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startRemotePortForwarding(SshdSocketAddress remote, SshdSocketAddress local) throws IOException {
        int port;
        Objects.requireNonNull(local, "Local address is null");
        Objects.requireNonNull(remote, "Remote address is null");
        String remoteHost = remote.getHostName();
        int remotePort = remote.getPort();
        Session session = this.getSession();
        Buffer buffer = session.createBuffer((byte)80, remoteHost.length() + 64);
        buffer.putString("tcpip-forward");
        buffer.putBoolean(true);
        buffer.putString(remoteHost);
        buffer.putUInt(remotePort);
        Duration timeout = CoreModuleProperties.FORWARD_REQUEST_TIMEOUT.getRequired(session);
        this.signalEstablishingExplicitTunnel(local, remote, false);
        try {
            Buffer result = session.request("tcpip-forward", buffer, timeout);
            if (result == null) {
                throw new SshException("Tcpip forwarding request denied by server");
            }
            port = remotePort == 0 ? result.getInt() : remote.getPort();
            Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
            synchronized (map) {
                SshdSocketAddress prev = this.remoteToLocal.get(port);
                if (prev != null) {
                    throw new IOException("Multiple remote port forwarding bindings on port=" + port + ": current=" + remote + ", previous=" + prev);
                }
                this.remoteToLocal.put(port, local);
            }
        }
        catch (IOException | RuntimeException e) {
            try {
                this.stopRemotePortForwarding(remote);
            }
            catch (IOException | RuntimeException err) {
                e.addSuppressed(err);
            }
            this.signalEstablishedExplicitTunnel(local, remote, false, null, e);
            throw e;
        }
        try {
            SshdSocketAddress bound = new SshdSocketAddress(remoteHost, port);
            if (this.log.isDebugEnabled()) {
                this.log.debug("startRemotePortForwarding({} -> {}): {}", new Object[]{remote, local, bound});
            }
            this.signalEstablishedExplicitTunnel(local, remote, false, bound, null);
            return bound;
        }
        catch (IOException | RuntimeException e) {
            this.stopRemotePortForwarding(remote);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopRemotePortForwarding(SshdSocketAddress remote) throws IOException {
        SshdSocketAddress bound;
        int port = remote.getPort();
        Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
        synchronized (map) {
            bound = this.remoteToLocal.remove(port);
        }
        if (bound != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("stopRemotePortForwarding({}) cancel forwarding to {}", (Object)remote, (Object)bound);
            }
            String remoteHost = remote.getHostName();
            Session session = this.getSession();
            Buffer buffer = session.createBuffer((byte)80, remoteHost.length() + 64);
            buffer.putString("cancel-tcpip-forward");
            buffer.putBoolean(false);
            buffer.putString(remoteHost);
            buffer.putUInt(port);
            this.signalTearingDownExplicitTunnel(bound, false, remote);
            try {
                session.writePacket(buffer);
            }
            catch (IOException | RuntimeException e) {
                this.signalTornDownExplicitTunnel(bound, false, remote, e);
                throw e;
            }
            this.signalTornDownExplicitTunnel(bound, false, remote, null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("stopRemotePortForwarding({}) no binding found", (Object)remote);
        }
    }

    protected void signalTearingDownExplicitTunnel(SshdSocketAddress boundAddress, boolean localForwarding, SshdSocketAddress remote) throws IOException {
        try {
            this.invokePortEventListenerSignaller(l -> {
                this.signalTearingDownExplicitTunnel((PortForwardingEventListener)l, boundAddress, localForwarding, remote);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to signal tearing down explicit tunnel for local=" + localForwarding + " on bound=" + boundAddress, t);
        }
    }

    protected void signalTearingDownExplicitTunnel(PortForwardingEventListener listener, SshdSocketAddress boundAddress, boolean localForwarding, SshdSocketAddress remoteAddress) throws IOException {
        if (listener == null) {
            return;
        }
        listener.tearingDownExplicitTunnel(this.getSession(), boundAddress, localForwarding, remoteAddress);
    }

    protected void signalTornDownExplicitTunnel(SshdSocketAddress boundAddress, boolean localForwarding, SshdSocketAddress remoteAddress, Throwable reason) throws IOException {
        try {
            this.invokePortEventListenerSignaller(l -> {
                this.signalTornDownExplicitTunnel((PortForwardingEventListener)l, boundAddress, localForwarding, remoteAddress, reason);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to signal torn down explicit tunnel local=" + localForwarding + " on bound=" + boundAddress, t);
        }
    }

    protected void signalTornDownExplicitTunnel(PortForwardingEventListener listener, SshdSocketAddress boundAddress, boolean localForwarding, SshdSocketAddress remoteAddress, Throwable reason) throws IOException {
        if (listener == null) {
            return;
        }
        listener.tornDownExplicitTunnel(this.getSession(), boundAddress, localForwarding, remoteAddress, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        int port;
        Objects.requireNonNull(local, "Local address is null");
        ValidateUtils.checkTrue(local.getPort() >= 0, "Invalid local port: %s", (Object)local);
        if (this.isClosed() || this.isClosing()) {
            throw new IllegalStateException("DefaultForwarder is closed or closing: " + this.state);
        }
        SocksProxy proxy = null;
        InetSocketAddress bound = null;
        this.signalEstablishingDynamicTunnel(local);
        try {
            bound = this.doBind(local, this.getDynamicIoAcceptor());
            port = bound.getPort();
            Object object = this.dynamicLock;
            synchronized (object) {
                SocksProxy prevProxy = this.dynamicLocal.get(port);
                if (prevProxy != null) {
                    throw new IOException("Multiple dynamic port mappings found for port=" + port + ": current=" + proxy + ", previous=" + prevProxy);
                }
                InetSocketAddress prevBound = this.boundDynamic.get(port);
                if (prevBound != null) {
                    throw new IOException("Multiple dynamic port bindings found for port=" + port + ": current=" + bound + ", previous=" + prevBound);
                }
                proxy = new SocksProxy(this.service);
                this.dynamicLocal.put(port, proxy);
                this.boundDynamic.put(port, bound);
            }
        }
        catch (IOException | RuntimeException e) {
            try {
                this.unbindDynamicForwarding(local, proxy, bound);
            }
            catch (IOException | RuntimeException err) {
                e.addSuppressed(err);
            }
            this.signalEstablishedDynamicTunnel(local, null, e);
            throw e;
        }
        try {
            SshdSocketAddress result = new SshdSocketAddress(bound.getHostString(), port);
            if (this.log.isDebugEnabled()) {
                this.log.debug("startDynamicPortForwarding({}): {}", (Object)local, (Object)result);
            }
            this.signalEstablishedDynamicTunnel(local, result, null);
            return result;
        }
        catch (IOException | RuntimeException e) {
            this.stopDynamicPortForwarding(local);
            throw e;
        }
    }

    protected void signalEstablishedDynamicTunnel(SshdSocketAddress local, SshdSocketAddress boundAddress, Throwable reason) throws IOException {
        try {
            this.invokePortEventListenerSignaller(l -> {
                this.signalEstablishedDynamicTunnel((PortForwardingEventListener)l, local, boundAddress, reason);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to signal establishing dynamic tunnel for local=" + local + " on bound=" + boundAddress, t);
        }
    }

    protected void signalEstablishedDynamicTunnel(PortForwardingEventListener listener, SshdSocketAddress local, SshdSocketAddress boundAddress, Throwable reason) throws IOException {
        if (listener == null) {
            return;
        }
        listener.establishedDynamicTunnel(this.getSession(), local, boundAddress, reason);
    }

    protected void signalEstablishingDynamicTunnel(SshdSocketAddress local) throws IOException {
        try {
            this.invokePortEventListenerSignaller(l -> {
                this.signalEstablishingDynamicTunnel((PortForwardingEventListener)l, local);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to signal establishing dynamic tunnel for local=" + local, t);
        }
    }

    protected void signalEstablishingDynamicTunnel(PortForwardingEventListener listener, SshdSocketAddress local) throws IOException {
        if (listener == null) {
            return;
        }
        listener.establishingDynamicTunnel(this.getSession(), local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        InetSocketAddress bound;
        SocksProxy proxy;
        int port = local.getPort();
        Object object = this.dynamicLock;
        synchronized (object) {
            proxy = this.dynamicLocal.remove(port);
            bound = this.boundDynamic.remove(port);
        }
        this.unbindDynamicForwarding(local, proxy, bound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void unbindDynamicForwarding(SshdSocketAddress local, SocksProxy proxy, InetSocketAddress bound) throws IOException {
        block24: {
            boolean debugEnabled = this.log.isDebugEnabled();
            if (bound == null && proxy == null) {
                if (!debugEnabled) return;
                this.log.debug("stopDynamicPortForwarding({}) no binding found", (Object)local);
                return;
            }
            try {
                this.signalTearingDownDynamicTunnel(local);
            }
            catch (Throwable throwable) {
                try {
                    block20: {
                        block21: {
                            try {
                                if (proxy != null) {
                                    if (debugEnabled) {
                                        this.log.debug("stopDynamicPortForwarding({}) close proxy={}", (Object)local, (Object)proxy);
                                    }
                                    proxy.close(true);
                                }
                                if (bound == null || this.dynamicAcceptor == null) break block20;
                                if (!debugEnabled) break block21;
                            }
                            catch (Throwable throwable2) {
                                if (bound != null && this.dynamicAcceptor != null) {
                                    if (debugEnabled) {
                                        this.log.debug("stopDynamicPortForwarding({}) unbind address={}", (Object)local, (Object)bound);
                                    }
                                    this.dynamicAcceptor.unbind(bound);
                                    throw throwable2;
                                }
                                if (!debugEnabled) throw throwable2;
                                this.log.debug("stopDynamicPortForwarding({}) no acceptor({}) or no binding({})", new Object[]{local, this.dynamicAcceptor, bound});
                                throw throwable2;
                            }
                            this.log.debug("stopDynamicPortForwarding({}) unbind address={}", (Object)local, (Object)bound);
                        }
                        this.dynamicAcceptor.unbind(bound);
                        throw throwable;
                    }
                    if (!debugEnabled) throw throwable;
                    this.log.debug("stopDynamicPortForwarding({}) no acceptor({}) or no binding({})", new Object[]{local, this.dynamicAcceptor, bound});
                    throw throwable;
                }
                catch (RuntimeException e) {
                    this.signalTornDownDynamicTunnel(local, e);
                    throw e;
                }
            }
            try {
                block22: {
                    block23: {
                        try {
                            if (proxy != null) {
                                if (debugEnabled) {
                                    this.log.debug("stopDynamicPortForwarding({}) close proxy={}", (Object)local, (Object)proxy);
                                }
                                proxy.close(true);
                            }
                            if (bound == null || this.dynamicAcceptor == null) break block22;
                            if (!debugEnabled) break block23;
                        }
                        catch (Throwable throwable) {
                            if (bound != null && this.dynamicAcceptor != null) {
                                if (debugEnabled) {
                                    this.log.debug("stopDynamicPortForwarding({}) unbind address={}", (Object)local, (Object)bound);
                                }
                                this.dynamicAcceptor.unbind(bound);
                                throw throwable;
                            }
                            if (!debugEnabled) throw throwable;
                            this.log.debug("stopDynamicPortForwarding({}) no acceptor({}) or no binding({})", new Object[]{local, this.dynamicAcceptor, bound});
                            throw throwable;
                        }
                        this.log.debug("stopDynamicPortForwarding({}) unbind address={}", (Object)local, (Object)bound);
                    }
                    this.dynamicAcceptor.unbind(bound);
                    break block24;
                }
                if (debugEnabled) {
                    this.log.debug("stopDynamicPortForwarding({}) no acceptor({}) or no binding({})", new Object[]{local, this.dynamicAcceptor, bound});
                }
            }
            catch (RuntimeException e) {
                this.signalTornDownDynamicTunnel(local, e);
                throw e;
            }
        }
        this.signalTornDownDynamicTunnel(local, null);
    }

    protected void signalTearingDownDynamicTunnel(SshdSocketAddress address) throws IOException {
        try {
            this.invokePortEventListenerSignaller(l -> {
                this.signalTearingDownDynamicTunnel((PortForwardingEventListener)l, address);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to signal tearing down dynamic tunnel for address=" + address, t);
        }
    }

    protected void signalTearingDownDynamicTunnel(PortForwardingEventListener listener, SshdSocketAddress address) throws IOException {
        if (listener == null) {
            return;
        }
        listener.tearingDownDynamicTunnel(this.getSession(), address);
    }

    protected void signalTornDownDynamicTunnel(SshdSocketAddress address, Throwable reason) throws IOException {
        try {
            this.invokePortEventListenerSignaller(l -> {
                this.signalTornDownDynamicTunnel((PortForwardingEventListener)l, address, reason);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to signal torn down dynamic tunnel for address=" + address, t);
        }
    }

    protected void signalTornDownDynamicTunnel(PortForwardingEventListener listener, SshdSocketAddress address, Throwable reason) throws IOException {
        if (listener == null) {
            return;
        }
        listener.tornDownDynamicTunnel(this.getSession(), address, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress getForwardedPort(int remotePort) {
        Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
        synchronized (map) {
            return this.remoteToLocal.get(remotePort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress localPortForwardingRequested(SshdSocketAddress local) throws IOException {
        SshdSocketAddress result;
        Objects.requireNonNull(local, "Local address is null");
        ValidateUtils.checkTrue(local.getPort() >= 0, "Invalid local port: %s", (Object)local);
        Session session = this.getSession();
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        TcpForwardingFilter filter = manager.getTcpForwardingFilter();
        try {
            if (filter == null || !filter.canListen(local, session)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("localPortForwardingRequested({})[{}][haveFilter={}] rejected", new Object[]{session, local, filter != null});
                }
                return null;
            }
        }
        catch (Error e) {
            this.warn("localPortForwardingRequested({})[{}] failed ({}) to consult forwarding filter: {}", session, local, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
        this.signalEstablishingExplicitTunnel(local, null, true);
        try {
            boolean added;
            InetSocketAddress bound = this.doBind(local, this.getLocalIoAcceptor());
            result = new SshdSocketAddress(bound);
            if (this.log.isDebugEnabled()) {
                this.log.debug("localPortForwardingRequested({}): {}", (Object)local, (Object)result);
            }
            LocalForwardingEntry localEntry = new LocalForwardingEntry(local, result);
            Set<LocalForwardingEntry> set = this.localForwards;
            synchronized (set) {
                added = this.localForwards.add(localEntry);
            }
            if (!added) {
                throw new IOException("Failed to add local port forwarding entry for " + local + " -> " + result);
            }
        }
        catch (IOException | Error | RuntimeException e) {
            try {
                this.localPortForwardingCancelled(local);
            }
            catch (IOException | Error | RuntimeException err) {
                e.addSuppressed(err);
            }
            this.signalEstablishedExplicitTunnel(local, null, true, null, e);
            throw e;
        }
        this.signalEstablishedExplicitTunnel(local, null, true, result, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void localPortForwardingCancelled(SshdSocketAddress local) throws IOException {
        LocalForwardingEntry entry;
        Set<LocalForwardingEntry> set = this.localForwards;
        synchronized (set) {
            entry = LocalForwardingEntry.findMatchingEntry(local.getHostName(), local.getPort(), this.localForwards);
            if (entry != null) {
                this.localForwards.remove(entry);
            }
        }
        if (entry != null && this.localAcceptor != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("localPortForwardingCancelled({}) unbind {}", (Object)local, (Object)entry);
            }
            SshdSocketAddress reportedBoundAddress = entry.getCombinedBoundAddress();
            this.signalTearingDownExplicitTunnel(reportedBoundAddress, true, null);
            SshdSocketAddress boundAddress = entry.getBoundAddress();
            try {
                this.localAcceptor.unbind(boundAddress.toInetSocketAddress());
            }
            catch (Error | RuntimeException e) {
                this.signalTornDownExplicitTunnel(reportedBoundAddress, true, null, e);
                throw e;
            }
            this.signalTornDownExplicitTunnel(reportedBoundAddress, true, null, null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("localPortForwardingCancelled({}) no match/acceptor: {}", (Object)local, (Object)entry);
        }
    }

    protected void signalEstablishingExplicitTunnel(SshdSocketAddress local, SshdSocketAddress remote, boolean localForwarding) throws IOException {
        try {
            this.invokePortEventListenerSignaller(l -> {
                this.signalEstablishingExplicitTunnel((PortForwardingEventListener)l, local, remote, localForwarding);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to signal establishing explicit tunnel for local=" + local + ", remote=" + remote + ", localForwarding=" + localForwarding, t);
        }
    }

    protected void signalEstablishingExplicitTunnel(PortForwardingEventListener listener, SshdSocketAddress local, SshdSocketAddress remote, boolean localForwarding) throws IOException {
        if (listener == null) {
            return;
        }
        listener.establishingExplicitTunnel(this.getSession(), local, remote, localForwarding);
    }

    protected void signalEstablishedExplicitTunnel(SshdSocketAddress local, SshdSocketAddress remote, boolean localForwarding, SshdSocketAddress boundAddress, Throwable reason) throws IOException {
        try {
            this.invokePortEventListenerSignaller(l -> {
                this.signalEstablishedExplicitTunnel((PortForwardingEventListener)l, local, remote, localForwarding, boundAddress, reason);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to signal established explicit tunnel for local=" + local + ", remote=" + remote + ", localForwarding=" + localForwarding + ", bound=" + boundAddress, t);
        }
    }

    protected void signalEstablishedExplicitTunnel(PortForwardingEventListener listener, SshdSocketAddress local, SshdSocketAddress remote, boolean localForwarding, SshdSocketAddress boundAddress, Throwable reason) throws IOException {
        if (listener == null) {
            return;
        }
        listener.establishedExplicitTunnel(this.getSession(), local, remote, localForwarding, boundAddress, reason);
    }

    protected void invokePortEventListenerSignaller(Invoker<PortForwardingEventListener, Void> invoker) throws Throwable {
        Throwable e;
        Throwable err = null;
        try {
            this.invokePortEventListenerSignallerListeners(this.getDefaultListeners(), invoker);
        }
        catch (Throwable t) {
            e = ExceptionUtils.peelException(t);
            err = ExceptionUtils.accumulateException(err, e);
        }
        try {
            this.invokePortEventListenerSignallerHolders(this.managersHolder, invoker);
        }
        catch (Throwable t) {
            e = ExceptionUtils.peelException(t);
            err = ExceptionUtils.accumulateException(err, e);
        }
        if (err != null) {
            throw err;
        }
    }

    protected void invokePortEventListenerSignallerListeners(Collection<? extends PortForwardingEventListener> listeners, Invoker<PortForwardingEventListener, Void> invoker) throws Throwable {
        if (GenericUtils.isEmpty(listeners)) {
            return;
        }
        Throwable err = null;
        for (PortForwardingEventListener portForwardingEventListener : listeners) {
            if (portForwardingEventListener == null) continue;
            try {
                invoker.invoke(portForwardingEventListener);
            }
            catch (Throwable t) {
                Throwable e = ExceptionUtils.peelException(t);
                err = ExceptionUtils.accumulateException(err, e);
            }
        }
        if (err != null) {
            throw err;
        }
    }

    protected void invokePortEventListenerSignallerHolders(Collection<? extends PortForwardingEventListenerManager> holders, Invoker<PortForwardingEventListener, Void> invoker) throws Throwable {
        if (GenericUtils.isEmpty(holders)) {
            return;
        }
        Throwable err = null;
        for (PortForwardingEventListenerManager portForwardingEventListenerManager : holders) {
            Throwable e;
            try {
                PortForwardingEventListener listener = portForwardingEventListenerManager.getPortForwardingEventListenerProxy();
                if (listener != null) {
                    invoker.invoke(listener);
                }
            }
            catch (Throwable t) {
                e = ExceptionUtils.peelException(t);
                err = ExceptionUtils.accumulateException(err, e);
            }
            if (!(portForwardingEventListenerManager instanceof PortForwardingEventListenerManagerHolder)) continue;
            try {
                this.invokePortEventListenerSignallerHolders(((PortForwardingEventListenerManagerHolder)((Object)portForwardingEventListenerManager)).getRegisteredManagers(), invoker);
            }
            catch (Throwable t) {
                e = ExceptionUtils.peelException(t);
                err = ExceptionUtils.accumulateException(err, e);
            }
        }
        if (err != null) {
            throw err;
        }
    }

    @Override
    protected synchronized Closeable getInnerCloseable() {
        return this.builder().parallel(this.toString(), this.dynamicLocal.values()).close(this.localAcceptor).close(this.dynamicAcceptor).build();
    }

    @Override
    protected void preClose() {
        this.listeners.clear();
        this.managersHolder.clear();
        super.preClose();
    }

    protected IoAcceptor createIoAcceptor(Factory<? extends IoHandler> handlerFactory) {
        Session session = this.getSession();
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        IoServiceFactory factory = Objects.requireNonNull(manager.getIoServiceFactory(), "No I/O service factory");
        IoHandler handler = handlerFactory.create();
        return factory.createAcceptor(handler);
    }

    protected IoAcceptor getLocalIoAcceptor() {
        if (this.localAcceptor == null) {
            this.localAcceptor = this.createIoAcceptor(this.staticIoHandlerFactory);
        }
        return this.localAcceptor;
    }

    protected IoAcceptor getDynamicIoAcceptor() {
        if (this.dynamicAcceptor == null) {
            this.dynamicAcceptor = this.createIoAcceptor(this.socksProxyIoHandlerFactory);
        }
        return this.dynamicAcceptor;
    }

    protected InetSocketAddress doBind(SshdSocketAddress address, IoAcceptor acceptor) throws IOException {
        Set<SocketAddress> before = acceptor.getBoundAddresses();
        try {
            InetSocketAddress bindAddress = address.toInetSocketAddress();
            acceptor.bind(bindAddress);
            Set<SocketAddress> after = acceptor.getBoundAddresses();
            if (GenericUtils.size(after) > 0) {
                after.removeAll(before);
            }
            if (GenericUtils.isEmpty(after)) {
                throw new IOException("Error binding to " + address + "[" + bindAddress + "]: no local addresses bound");
            }
            if (after.size() > 1) {
                throw new IOException("Multiple local addresses have been bound for " + address + "[" + bindAddress + "]");
            }
            InetSocketAddress boundAddress = (InetSocketAddress)GenericUtils.head(after);
            return boundAddress;
        }
        catch (IOException bindErr) {
            Set<SocketAddress> after = acceptor.getBoundAddresses();
            if (GenericUtils.isEmpty(after)) {
                this.close();
            }
            throw bindErr;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getSession() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SshdSocketAddress> getBoundLocalPortForwards(int port) {
        Object object = this.localLock;
        synchronized (object) {
            return this.localToRemote.isEmpty() ? Collections.emptyList() : this.localToRemote.keySet().stream().filter(k -> k.getPort() == port).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLocalPortForwardingStartedForPort(int port) {
        Object object = this.localLock;
        synchronized (object) {
            return this.localToRemote.keySet().stream().anyMatch(e -> e.getPort() == port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map.Entry<SshdSocketAddress, SshdSocketAddress>> getLocalForwardsBindings() {
        Object object = this.localLock;
        synchronized (object) {
            return this.localToRemote.isEmpty() ? Collections.emptyList() : (List)this.localToRemote.entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry<SshdSocketAddress, SshdSocketAddress>((SshdSocketAddress)e.getKey(), (SshdSocketAddress)e.getValue())).collect(Collectors.toCollection(() -> new ArrayList(this.localToRemote.size())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SshdSocketAddress> getStartedLocalPortForwards() {
        Object object = this.localLock;
        synchronized (object) {
            return this.localToRemote.isEmpty() ? Collections.emptyList() : new ArrayList<SshdSocketAddress>(this.localToRemote.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map.Entry<Integer, SshdSocketAddress>> getRemoteForwardsBindings() {
        Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
        synchronized (map) {
            return this.remoteToLocal.isEmpty() ? Collections.emptyList() : (List)this.remoteToLocal.entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry<Integer, SshdSocketAddress>((Integer)e.getKey(), (SshdSocketAddress)e.getValue())).collect(Collectors.toCollection(() -> new ArrayList(this.remoteToLocal.size())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SshdSocketAddress getBoundRemotePortForward(int port) {
        ValidateUtils.checkTrue(port > 0, "Invalid remote port: %d", port);
        Integer portKey = port;
        Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
        synchronized (map) {
            return this.remoteToLocal.get(portKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigableSet<Integer> getStartedRemotePortForwards() {
        Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
        synchronized (map) {
            return this.remoteToLocal.isEmpty() ? Collections.emptyNavigableSet() : GenericUtils.asSortedSet(this.remoteToLocal.keySet());
        }
    }

    class StaticIoHandler
    implements IoHandler {
        private final AtomicLong messagesCounter = new AtomicLong(0L);

        StaticIoHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sessionCreated(IoSession session) throws Exception {
            SshdSocketAddress remote;
            InetSocketAddress localAddress = (InetSocketAddress)session.getLocalAddress();
            SshdSocketAddress local = new SshdSocketAddress(localAddress);
            Object object = DefaultForwarder.this.localLock;
            synchronized (object) {
                remote = (SshdSocketAddress)SshdSocketAddress.findByOptionalWildcardAddress(DefaultForwarder.this.localToRemote, local);
            }
            TcpipClientChannel.Type channelType = remote == null ? TcpipClientChannel.Type.Forwarded : TcpipClientChannel.Type.Direct;
            TcpipClientChannel channel = new TcpipClientChannel(channelType, session, remote);
            channel.setStreaming(StreamingChannel.Streaming.Async);
            session.setAttribute(TcpipClientChannel.class, channel);
            session.suspendRead();
            if (channelType == TcpipClientChannel.Type.Forwarded) {
                SocketAddress accepted = session.getAcceptanceAddress();
                LocalForwardingEntry localEntry = null;
                if (accepted instanceof InetSocketAddress) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)accepted;
                    InetAddress inetAddress = inetSocketAddress.getAddress();
                    Set set = DefaultForwarder.this.localForwards;
                    synchronized (set) {
                        localEntry = LocalForwardingEntry.findMatchingEntry(inetSocketAddress.getHostString(), inetAddress.isAnyLocalAddress(), local.getPort(), DefaultForwarder.this.localForwards);
                    }
                }
                if (localEntry != null) {
                    if (DefaultForwarder.this.log.isDebugEnabled()) {
                        DefaultForwarder.this.log.debug("sessionCreated({})[local={}, remote={}, accepted={}] localEntry={}", new Object[]{session, local, remote, accepted, localEntry});
                    }
                    channel.updateLocalForwardingEntry(localEntry);
                } else {
                    DefaultForwarder.this.log.warn("sessionCreated({})[local={}, remote={}] cannot locate original local entry for accepted={}", new Object[]{session, local, remote, accepted});
                }
            } else if (DefaultForwarder.this.log.isDebugEnabled()) {
                DefaultForwarder.this.log.debug("sessionCreated({}) local={}, remote={}", new Object[]{session, local, remote});
            }
            DefaultForwarder.this.service.registerChannel(channel);
            channel.open().addListener(future -> {
                session.resumeRead();
                Throwable t = future.getException();
                if (t != null) {
                    DefaultForwarder.this.warn("Failed ({}) to open channel for session={}: {}", t.getClass().getSimpleName(), session, t.getMessage(), t);
                    DefaultForwarder.this.service.unregisterChannel(channel);
                    channel.close(false);
                }
            });
        }

        @Override
        public void sessionClosed(IoSession session) throws Exception {
            TcpipClientChannel channel = (TcpipClientChannel)session.removeAttribute(TcpipClientChannel.class);
            Throwable cause = (Throwable)session.removeAttribute(TcpipForwardingExceptionMarker.class);
            if (DefaultForwarder.this.log.isDebugEnabled()) {
                DefaultForwarder.this.log.debug("sessionClosed({}) closing channel={} after {} messages - cause={}", new Object[]{session, channel, this.messagesCounter, cause == null ? null : cause.getClass().getSimpleName()});
            }
            if (channel == null) {
                return;
            }
            channel.close(cause != null);
        }

        @Override
        public void messageReceived(IoSession session, Readable message) throws Exception {
            TcpipClientChannel channel = (TcpipClientChannel)session.getAttribute(TcpipClientChannel.class);
            long totalMessages = this.messagesCounter.incrementAndGet();
            ByteArrayBuffer buffer = new ByteArrayBuffer(message.available(), false);
            buffer.putBuffer(message);
            if (DefaultForwarder.this.log.isTraceEnabled()) {
                DefaultForwarder.this.log.trace("messageReceived({}) channel={}, count={}, handle len={}", new Object[]{session, channel, totalMessages, message.available()});
            }
            session.suspendRead();
            ThreadUtils.runAsInternal(() -> channel.getAsyncIn().writeBuffer(buffer).addListener(f -> {
                session.resumeRead();
                Throwable e = f.getException();
                if (e != null) {
                    try {
                        this.exceptionCaught(session, e);
                    }
                    catch (Exception err) {
                        DefaultForwarder.this.warn("messageReceived({}) failed ({}) to signal {}[{}] on channel={}: {}", session, err.getClass().getSimpleName(), e.getClass().getSimpleName(), e.getMessage(), channel, err.getMessage(), err);
                    }
                } else if (DefaultForwarder.this.log.isTraceEnabled()) {
                    DefaultForwarder.this.log.trace("messageReceived({}) channel={} message={} forwarded", new Object[]{session, channel, totalMessages});
                }
            }));
        }

        @Override
        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            session.setAttribute(TcpipForwardingExceptionMarker.class, cause);
            DefaultForwarder.this.log.warn("exceptionCaught({}) {}: {}", new Object[]{session, cause.getClass().getSimpleName(), cause.getMessage(), cause});
            session.close(true);
        }
    }
}

