/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.forward;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opendaylight.netconf.shaded.sshd.common.forward.DefaultForwarder;
import org.opendaylight.netconf.shaded.sshd.common.forward.Forwarder;
import org.opendaylight.netconf.shaded.sshd.common.forward.ForwarderFactory;
import org.opendaylight.netconf.shaded.sshd.common.forward.PortForwardingEventListener;
import org.opendaylight.netconf.shaded.sshd.common.forward.PortForwardingEventListenerManager;
import org.opendaylight.netconf.shaded.sshd.common.session.ConnectionService;
import org.opendaylight.netconf.shaded.sshd.common.util.EventListenerUtils;

public class DefaultForwarderFactory
implements ForwarderFactory,
PortForwardingEventListenerManager {
    public static final DefaultForwarderFactory INSTANCE = new DefaultForwarderFactory(){

        @Override
        public void addPortForwardingEventListener(PortForwardingEventListener listener) {
            throw new UnsupportedOperationException("addPortForwardingListener(" + listener + ") N/A on default instance");
        }

        @Override
        public void removePortForwardingEventListener(PortForwardingEventListener listener) {
            throw new UnsupportedOperationException("removePortForwardingEventListener(" + listener + ") N/A on default instance");
        }

        @Override
        public PortForwardingEventListener getPortForwardingEventListenerProxy() {
            return PortForwardingEventListener.EMPTY;
        }
    };
    private final Collection<PortForwardingEventListener> listeners = new CopyOnWriteArraySet<PortForwardingEventListener>();
    private final PortForwardingEventListener listenerProxy = EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.listeners);

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.listenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener listener) {
        this.listeners.add(PortForwardingEventListener.validateListener(listener));
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(PortForwardingEventListener.validateListener(listener));
    }

    @Override
    public Forwarder create(ConnectionService service) {
        DefaultForwarder forwarder = new DefaultForwarder(service);
        forwarder.addPortForwardingEventListenerManager(this);
        return forwarder;
    }
}

