/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.future;

import org.opendaylight.netconf.shaded.sshd.common.SshException;
import org.opendaylight.netconf.shaded.sshd.common.future.DefaultSshFuture;
import org.opendaylight.netconf.shaded.sshd.common.future.HasException;
import org.opendaylight.netconf.shaded.sshd.common.future.SshFutureListener;
import org.opendaylight.netconf.shaded.sshd.common.io.IoWriteFuture;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;

public class GlobalRequestFuture
extends DefaultSshFuture<GlobalRequestFuture>
implements HasException,
SshFutureListener<IoWriteFuture> {
    private final ReplyHandler handler;
    private long sequenceNumber;

    public GlobalRequestFuture(String request) {
        this(request, null);
    }

    public GlobalRequestFuture(String request, ReplyHandler handler) {
        super(request, null);
        this.handler = handler;
    }

    @Override
    public String getId() {
        return (String)super.getId();
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long number) {
        if (number < 0L || (number & 0xFFFFFFFFL) != number) {
            throw new IllegalArgumentException("Invalid sequence number " + number);
        }
        this.sequenceNumber = number;
    }

    public ReplyHandler getHandler() {
        return this.handler;
    }

    public Buffer getBuffer() {
        Object value = this.getValue();
        if (value instanceof Buffer) {
            return (Buffer)value;
        }
        return null;
    }

    @Override
    public Throwable getException() {
        Object value = this.getValue();
        if (value instanceof Throwable) {
            return (Throwable)value;
        }
        return null;
    }

    @Override
    public void operationComplete(IoWriteFuture future) {
        if (!future.isWritten()) {
            Throwable ioe = future.getException();
            if (ioe != null) {
                this.setValue(ioe);
            } else {
                this.setValue(new SshException("Could not write global request " + this.getId() + " seqNo=" + this.getSequenceNumber()));
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[seqNo=" + this.sequenceNumber + ']';
    }

    @FunctionalInterface
    public static interface ReplyHandler {
        public void accept(int var1, Buffer var2);
    }
}

