/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.kex;

import java.security.KeyPair;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.kex.AbstractDH;
import org.opendaylight.netconf.shaded.sshd.common.kex.MontgomeryCurve;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;

public abstract class XDH
extends AbstractDH {
    protected final MontgomeryCurve curve;
    protected final boolean raw;
    protected byte[] f;

    public XDH(MontgomeryCurve curve, boolean raw) throws Exception {
        this.curve = Objects.requireNonNull(curve, "No MontgomeryCurve provided");
        this.raw = raw;
        this.myKeyAgree = curve.createKeyAgreement();
    }

    public int getKeySize() {
        return this.curve.getKeySize();
    }

    @Override
    protected byte[] calculateE() throws Exception {
        KeyPair keyPair = this.curve.generateKeyPair();
        this.myKeyAgree.init(keyPair.getPrivate());
        return this.curve.encode(keyPair.getPublic());
    }

    @Override
    public void setF(byte[] f) {
        this.f = Objects.requireNonNull(f, "No 'f' value provided");
    }

    @Override
    public void putE(Buffer buffer, byte[] e) {
        buffer.putBytes(e);
    }

    @Override
    public void putF(Buffer buffer, byte[] f) {
        buffer.putBytes(f);
    }

    @Override
    protected byte[] calculateK() throws Exception {
        Objects.requireNonNull(this.f, "Missing 'f' value");
        this.myKeyAgree.doPhase(this.curve.decode(this.f), true);
        byte[] secret = this.myKeyAgree.generateSecret();
        return this.raw ? secret : XDH.stripLeadingZeroes(secret);
    }
}

