/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.kex.extension;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.netconf.shaded.sshd.common.kex.KexProposalOption;
import org.opendaylight.netconf.shaded.sshd.common.session.Session;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;

public interface KexExtensionHandler {
    default public boolean isKexExtensionsAvailable(Session session, AvailabilityPhase phase) throws IOException {
        return true;
    }

    default public void handleKexInitProposal(Session session, boolean initiator, Map<KexProposalOption, String> proposal) throws Exception {
    }

    default public void handleKexExtensionNegotiation(Session session, KexProposalOption option, String nValue, Map<KexProposalOption, String> c2sOptions, String cValue, Map<KexProposalOption, String> s2cOptions, String sValue) throws Exception {
    }

    default public void sendKexExtensions(Session session, KexPhase phase) throws Exception {
    }

    default public boolean handleKexExtensionsMessage(Session session, Buffer buffer) throws Exception {
        byte[] data;
        String name;
        int count = buffer.getInt();
        for (int index = 0; index < count && this.handleKexExtensionRequest(session, index, count, name = buffer.getString(), data = buffer.getBytes()); ++index) {
        }
        return true;
    }

    default public boolean handleKexCompressionMessage(Session session, Buffer buffer) throws Exception {
        return true;
    }

    default public boolean handleKexExtensionRequest(Session session, int index, int count, String name, byte[] data) throws Exception {
        return true;
    }

    public static enum KexPhase {
        NEWKEYS,
        AUTHOK;

        public static final Set<KexPhase> VALUES;

        static {
            VALUES = Collections.unmodifiableSet(EnumSet.allOf(KexPhase.class));
        }
    }

    public static enum AvailabilityPhase {
        PREKEX,
        PROPOSAL,
        NEWKEYS,
        AUTHOK;

    }
}

