/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.session;

import java.io.IOException;
import java.net.SocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opendaylight.netconf.shaded.sshd.common.AttributeRepository;
import org.opendaylight.netconf.shaded.sshd.common.FactoryManager;
import org.opendaylight.netconf.shaded.sshd.common.FactoryManagerHolder;
import org.opendaylight.netconf.shaded.sshd.common.Service;
import org.opendaylight.netconf.shaded.sshd.common.auth.MutableUserHolder;
import org.opendaylight.netconf.shaded.sshd.common.channel.ChannelListenerManager;
import org.opendaylight.netconf.shaded.sshd.common.channel.throttle.ChannelStreamWriterResolverManager;
import org.opendaylight.netconf.shaded.sshd.common.forward.PortForwardingEventListenerManager;
import org.opendaylight.netconf.shaded.sshd.common.forward.PortForwardingInformationProvider;
import org.opendaylight.netconf.shaded.sshd.common.future.GlobalRequestFuture;
import org.opendaylight.netconf.shaded.sshd.common.future.KeyExchangeFuture;
import org.opendaylight.netconf.shaded.sshd.common.io.IoSession;
import org.opendaylight.netconf.shaded.sshd.common.io.IoWriteFuture;
import org.opendaylight.netconf.shaded.sshd.common.kex.KexFactoryManager;
import org.opendaylight.netconf.shaded.sshd.common.kex.KeyExchange;
import org.opendaylight.netconf.shaded.sshd.common.session.ReservedSessionMessagesManager;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionContext;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionDisconnectHandlerManager;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionListenerManager;
import org.opendaylight.netconf.shaded.sshd.common.session.UnknownChannelReferenceHandlerManager;
import org.opendaylight.netconf.shaded.sshd.common.session.helpers.TimeoutIndicator;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;

public interface Session
extends SessionContext,
MutableUserHolder,
KexFactoryManager,
SessionListenerManager,
ReservedSessionMessagesManager,
SessionDisconnectHandlerManager,
ChannelListenerManager,
ChannelStreamWriterResolverManager,
PortForwardingEventListenerManager,
UnknownChannelReferenceHandlerManager,
FactoryManagerHolder,
PortForwardingInformationProvider {
    default public Buffer createBuffer(byte cmd) {
        return this.createBuffer(cmd, 0);
    }

    public Buffer createBuffer(byte var1, int var2);

    public Buffer prepareBuffer(byte var1, Buffer var2);

    public IoWriteFuture sendDebugMessage(boolean var1, Object var2, String var3) throws IOException;

    public IoWriteFuture sendIgnoreMessage(byte ... var1) throws IOException;

    public IoWriteFuture writePacket(Buffer var1) throws IOException;

    default public IoWriteFuture writePacket(Buffer buffer, Duration timeout) throws IOException {
        Objects.requireNonNull(timeout, "No timeout was specified");
        return this.writePacket(buffer, timeout.toMillis());
    }

    default public IoWriteFuture writePacket(Buffer buffer, long maxWaitMillis) throws IOException {
        return this.writePacket(buffer, maxWaitMillis, TimeUnit.MILLISECONDS);
    }

    public IoWriteFuture writePacket(Buffer var1, long var2, TimeUnit var4) throws IOException;

    default public Buffer request(String request, Buffer buffer, long timeout, TimeUnit unit) throws IOException {
        ValidateUtils.checkTrue(timeout > 0L, "Non-positive timeout requested: %d", timeout);
        return this.request(request, buffer, TimeUnit.MILLISECONDS.convert(timeout, unit));
    }

    default public Buffer request(String request, Buffer buffer, Duration timeout) throws IOException {
        Objects.requireNonNull(timeout, "No timeout specified");
        return this.request(request, buffer, timeout.toMillis());
    }

    public Buffer request(String var1, Buffer var2, long var3) throws IOException;

    public GlobalRequestFuture request(Buffer var1, String var2, GlobalRequestFuture.ReplyHandler var3) throws IOException;

    public void exceptionCaught(Throwable var1);

    public KeyExchangeFuture reExchangeKeys() throws IOException;

    public <T extends Service> T getService(Class<T> var1);

    public IoSession getIoSession();

    @Override
    default public SocketAddress getLocalAddress() {
        IoSession s = this.getIoSession();
        return s == null ? null : s.getLocalAddress();
    }

    @Override
    default public SocketAddress getRemoteAddress() {
        IoSession s = this.getIoSession();
        return s == null ? null : s.getRemoteAddress();
    }

    public TimeoutIndicator getTimeoutStatus();

    public Duration getIdleTimeout();

    public Instant getIdleTimeoutStart();

    public Instant resetIdleTimeout();

    public Duration getAuthTimeout();

    public Instant getAuthTimeoutStart();

    public Instant resetAuthTimeout();

    public void setAuthenticated() throws IOException;

    public KeyExchange getKex();

    public void disconnect(int var1, String var2) throws IOException;

    public void startService(String var1, Buffer var2) throws Exception;

    @Override
    default public <T> T resolveAttribute(AttributeRepository.AttributeKey<T> key) {
        return Session.resolveAttribute(this, key);
    }

    public static <T> T resolveAttribute(Session session, AttributeRepository.AttributeKey<T> key) {
        Objects.requireNonNull(key, "No key");
        if (session == null) {
            return null;
        }
        T value = session.getAttribute(key);
        return value != null ? value : FactoryManager.resolveAttribute(session.getFactoryManager(), key);
    }
}

