/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.signature;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opendaylight.netconf.shaded.sshd.common.NamedFactory;
import org.opendaylight.netconf.shaded.sshd.common.signature.BuiltinSignatures;
import org.opendaylight.netconf.shaded.sshd.common.signature.Signature;
import org.opendaylight.netconf.shaded.sshd.common.signature.SignatureFactoriesHolder;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;

public interface SignatureFactoriesManager
extends SignatureFactoriesHolder {
    public void setSignatureFactories(List<NamedFactory<Signature>> var1);

    default public void setSignatureFactoriesNameList(String names) {
        this.setSignatureFactoriesNames(GenericUtils.split(names, ','));
    }

    default public void setSignatureFactoriesNames(String ... names) {
        this.setSignatureFactoriesNames(GenericUtils.isEmpty((Object[])names) ? Collections.emptyList() : Arrays.asList(names));
    }

    default public void setSignatureFactoriesNames(Collection<String> names) {
        BuiltinSignatures.ParseResult result = BuiltinSignatures.parseSignatureList(names);
        List<NamedFactory<Signature>> factories = ValidateUtils.checkNotNullAndNotEmpty(result.getParsedFactories(), "No supported signature factories: %s", names);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(unsupported), "Unsupported signature factories found: %s", unsupported);
        this.setSignatureFactories(factories);
    }

    public static List<NamedFactory<Signature>> resolveSignatureFactories(SignatureFactoriesManager primary, SignatureFactoriesManager secondary) {
        List<NamedFactory<Signature>> factories = SignatureFactoriesManager.getSignatureFactories(primary);
        return GenericUtils.isEmpty(factories) ? SignatureFactoriesManager.getSignatureFactories(secondary) : factories;
    }

    public static List<NamedFactory<Signature>> getSignatureFactories(SignatureFactoriesManager manager) {
        return manager == null ? null : manager.getSignatureFactories();
    }
}

