/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import org.opendaylight.netconf.shaded.sshd.common.util.OsUtils;

public final class ExceptionUtils {
    private ExceptionUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static void rethrowAsIoException(Throwable e) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new IOException(e);
    }

    public static <T extends Throwable> T accumulateException(T current, T extra) {
        if (current == null) {
            return extra;
        }
        if (extra == null || extra == current) {
            return current;
        }
        current.addSuppressed(extra);
        return current;
    }

    public static Throwable resolveExceptionCause(Throwable t) {
        if (t == null) {
            return t;
        }
        Throwable c = t.getCause();
        if (c == null) {
            return t;
        }
        return c;
    }

    public static Throwable peelException(Throwable t) {
        Throwable target;
        if (t == null) {
            return t;
        }
        if (t instanceof UndeclaredThrowableException) {
            Throwable wrapped = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
            if (wrapped != null) {
                return ExceptionUtils.peelException(wrapped);
            }
            wrapped = t.getCause();
            if (wrapped != t) {
                return ExceptionUtils.peelException(wrapped);
            }
        } else if (t instanceof InvocationTargetException) {
            target = ((InvocationTargetException)t).getTargetException();
            if (target != null) {
                return ExceptionUtils.peelException(target);
            }
        } else if (t instanceof ExecutionException) {
            return ExceptionUtils.peelException(ExceptionUtils.resolveExceptionCause(t));
        }
        if (!OsUtils.isAndroid() && (t instanceof ReflectionException ? (target = ((ReflectionException)t).getTargetException()) != null : t instanceof MBeanException && (target = ((MBeanException)t).getTargetException()) != null)) {
            return ExceptionUtils.peelException(target);
        }
        return t;
    }

    public static RuntimeException toRuntimeException(Throwable t, boolean peelThrowable) {
        Throwable e;
        Throwable throwable = e = peelThrowable ? ExceptionUtils.peelException(t) : t;
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static RuntimeException toRuntimeException(Throwable t) {
        return ExceptionUtils.toRuntimeException(t, true);
    }
}

