/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;

public final class ProxyUtils {
    private ProxyUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static <T> T newProxyInstance(Class<T> type, InvocationHandler handler) {
        return ProxyUtils.newProxyInstance(type.getClassLoader(), type, handler);
    }

    public static <T> T newProxyInstance(ClassLoader cl, Class<T> type, InvocationHandler handler) {
        Class[] interfaces = new Class[]{type};
        Object wrapper = Proxy.newProxyInstance(cl, interfaces, handler);
        return type.cast(wrapper);
    }

    public static Throwable unwrapInvocationThrowable(Throwable t) {
        if (t instanceof InvocationTargetException) {
            return ProxyUtils.unwrapInvocationThrowable(((InvocationTargetException)t).getTargetException());
        }
        return t;
    }
}

