/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util;

import java.io.File;
import java.nio.file.FileSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;

public final class SelectorUtils {
    public static final String PATTERN_HANDLER_PREFIX = "[";
    public static final String PATTERN_HANDLER_SUFFIX = "]";
    public static final String REGEX_HANDLER_PREFIX = "%regex[";
    public static final String ANT_HANDLER_PREFIX = "%ant[";

    private SelectorUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static boolean matchPatternStart(String pattern, String str) {
        return SelectorUtils.matchPatternStart(pattern, str, true);
    }

    public static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath(pattern, str, File.separator, isCaseSensitive);
    }

    public static boolean matchPatternStart(String pattern, String str, String separator, boolean isCaseSensitive) {
        if (pattern.length() > REGEX_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern.startsWith(REGEX_HANDLER_PREFIX) && pattern.endsWith(PATTERN_HANDLER_SUFFIX)) {
            return true;
        }
        if (pattern.length() > ANT_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern.startsWith(ANT_HANDLER_PREFIX) && pattern.endsWith(PATTERN_HANDLER_SUFFIX)) {
            pattern = pattern.substring(ANT_HANDLER_PREFIX.length(), pattern.length() - PATTERN_HANDLER_SUFFIX.length());
        }
        if (SelectorUtils.matchAntPathPatternStart(pattern, str, separator, isCaseSensitive)) {
            return true;
        }
        return SelectorUtils.matchAntPathPatternStart(pattern, str.replace('\\', '/'), "/", isCaseSensitive);
    }

    public static boolean matchAntPathPatternStart(String pattern, String str, String separator, boolean isCaseSensitive) {
        String patDir;
        int strIdxStart;
        if (str.startsWith(separator) != pattern.startsWith(separator)) {
            return false;
        }
        List<String> patDirs = SelectorUtils.tokenizePath(pattern, separator);
        List<String> strDirs = SelectorUtils.tokenizePath(str, separator);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.size() - 1;
        int strIdxEnd = strDirs.size() - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs.get(patIdxStart)).equals("**"); ++patIdxStart, ++strIdxStart) {
            if (SelectorUtils.match(patDir, strDirs.get(strIdxStart), isCaseSensitive)) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            return true;
        }
        return patIdxStart <= patIdxEnd;
    }

    public static boolean matchPath(String pattern, String str) {
        return SelectorUtils.matchPath(pattern, str, true);
    }

    public static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath(pattern, str, File.separator, isCaseSensitive);
    }

    public static boolean matchPath(String pattern, String str, String separator, boolean isCaseSensitive) {
        if (pattern.length() > REGEX_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern.startsWith(REGEX_HANDLER_PREFIX) && pattern.endsWith(PATTERN_HANDLER_SUFFIX)) {
            pattern = pattern.substring(REGEX_HANDLER_PREFIX.length(), pattern.length() - PATTERN_HANDLER_SUFFIX.length());
            return str.matches(pattern);
        }
        if (pattern.length() > ANT_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern.startsWith(ANT_HANDLER_PREFIX) && pattern.endsWith(PATTERN_HANDLER_SUFFIX)) {
            pattern = pattern.substring(ANT_HANDLER_PREFIX.length(), pattern.length() - PATTERN_HANDLER_SUFFIX.length());
        }
        return SelectorUtils.matchAntPathPattern(pattern, str, separator, isCaseSensitive);
    }

    public static boolean matchAntPathPattern(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchAntPathPattern(pattern, str, File.separator, isCaseSensitive);
    }

    public static boolean matchAntPathPattern(String pattern, String str, String separator, boolean isCaseSensitive) {
        String subPat;
        String subDir;
        String patDir;
        int strIdxStart;
        if (str.startsWith(separator) != pattern.startsWith(separator)) {
            return false;
        }
        List<String> patDirs = SelectorUtils.tokenizePath(pattern, separator);
        List<String> strDirs = SelectorUtils.tokenizePath(str, separator);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.size() - 1;
        int strIdxEnd = strDirs.size() - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs.get(patIdxStart)).equals("**"); ++patIdxStart, ++strIdxStart) {
            subDir = strDirs.get(strIdxStart);
            if (SelectorUtils.match(patDir, subDir, isCaseSensitive)) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                subPat = patDirs.get(i);
                if (subPat.equals("**")) continue;
                return false;
            }
            return true;
        }
        if (patIdxStart > patIdxEnd) {
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs.get(patIdxEnd)).equals("**")) {
            subDir = strDirs.get(strIdxEnd);
            if (!SelectorUtils.match(patDir, subDir, isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                subPat = patDirs.get(i);
                if (subPat.equals("**")) continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i = patIdxStart + 1; i <= patIdxEnd; ++i) {
                String subPat2 = patDirs.get(i);
                if (!subPat2.equals("**")) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subStr;
                    String subPat3 = patDirs.get(patIdxStart + j + 1);
                    if (!SelectorUtils.match(subPat3, subStr = strDirs.get(strIdxStart + i + j), isCaseSensitive)) continue block6;
                }
                foundIdx = strIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i = patIdxStart; i <= patIdxEnd; ++i) {
            String subPat4 = patDirs.get(i);
            if (subPat4.equals("**")) continue;
            return false;
        }
        return true;
    }

    public static boolean match(String pattern, String str) {
        return SelectorUtils.match(pattern, str, true);
    }

    public static boolean match(String pattern, String str, boolean isCaseSensitive) {
        char ch;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (char aPatArr : patArr) {
            if (aPatArr != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (int i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?' || SelectorUtils.equals(ch2, strArr[i], isCaseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && !SelectorUtils.equals(ch, strArr[strIdxStart], isCaseSensitive)) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && !SelectorUtils.equals(ch, strArr[strIdxEnd], isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i = patIdxStart + 1; i <= patIdxEnd; ++i) {
                if (patArr[i] != '*') continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && !SelectorUtils.equals(ch, strArr[strIdxStart + i + j], isCaseSensitive)) continue block8;
                }
                foundIdx = strIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char c1, char c2, boolean isCaseSensitive) {
        if (c1 == c2) {
            return true;
        }
        return !isCaseSensitive && (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2));
    }

    public static List<String> tokenizePath(String path) {
        return SelectorUtils.tokenizePath(path, File.separator);
    }

    public static List<String> tokenizePath(String path, String separator) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, separator);
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret;
    }

    public static String translateToLocalFileSystemPath(String path, char pathSeparator, FileSystem fs) {
        return SelectorUtils.translateToLocalFileSystemPath(path, pathSeparator, Objects.requireNonNull(fs, "No target file system").getSeparator());
    }

    public static String translateToLocalFileSystemPath(String path, char pathSeparator, String fsSeparator) {
        String slashified = SelectorUtils.applySlashifyRules(path, pathSeparator);
        String localPath = SelectorUtils.translateToLocalPath(slashified);
        return SelectorUtils.translateToFileSystemPath(localPath, File.separator, fsSeparator);
    }

    public static String applySlashifyRules(String path, char sepChar) {
        if (GenericUtils.isEmpty(path)) {
            return path;
        }
        int curPos = path.indexOf(sepChar);
        if (curPos < 0) {
            return path;
        }
        int lastPos = 0;
        StringBuilder sb = null;
        while (curPos < path.length()) {
            int nextPos;
            for (nextPos = ++curPos; nextPos < path.length() && path.charAt(nextPos) == sepChar; ++nextPos) {
            }
            int seqLen = nextPos - curPos;
            if (seqLen > 0) {
                if (sb == null) {
                    sb = new StringBuilder(path.length() - seqLen);
                }
                if (lastPos < curPos) {
                    String clrText = path.substring(lastPos, curPos);
                    sb.append(clrText);
                }
                lastPos = nextPos;
            }
            if (nextPos < path.length() && (curPos = path.indexOf(sepChar, nextPos)) >= nextPos) continue;
            break;
        }
        if (sb != null) {
            if (lastPos < path.length()) {
                String clrText = path.substring(lastPos);
                sb.append(clrText);
            }
            path = sb.toString();
        }
        if (path.length() > 1 && path.charAt(path.length() - 1) == sepChar) {
            return path + ".";
        }
        return path;
    }

    public static String translateToLocalPath(String path) {
        if (GenericUtils.isEmpty(path) || File.separatorChar == '/') {
            return path;
        }
        String localPath = path.replace('/', File.separatorChar);
        if (localPath.charAt(0) == File.separatorChar && SelectorUtils.isWindowsDriveSpecified(localPath, 1, localPath.length() - 1)) {
            localPath = localPath.substring(1);
        }
        if (!SelectorUtils.isWindowsDriveSpecified(localPath)) {
            return localPath;
        }
        if (localPath.length() == 2) {
            return localPath + File.separator;
        }
        if (localPath.charAt(2) != File.separatorChar) {
            return localPath.substring(0, 2) + File.separator + localPath.substring(2);
        }
        return localPath;
    }

    public static boolean isWindowsDriveSpecified(CharSequence cs) {
        return SelectorUtils.isWindowsDriveSpecified(cs, 0, GenericUtils.length(cs));
    }

    public static boolean isWindowsDriveSpecified(CharSequence cs, int offset, int len) {
        if (len < 2 || cs.charAt(offset + 1) != ':') {
            return false;
        }
        char drive = cs.charAt(offset);
        return drive >= 'a' && drive <= 'z' || drive >= 'A' && drive <= 'Z';
    }

    public static String translateToFileSystemPath(String path, String pathSeparator, FileSystem fs) {
        return SelectorUtils.translateToFileSystemPath(path, pathSeparator, Objects.requireNonNull(fs, "No target file system").getSeparator());
    }

    public static String translateToFileSystemPath(String path, String pathSeparator, String fsSeparator) {
        ValidateUtils.checkNotNullAndNotEmpty(pathSeparator, "Missing path separator");
        ValidateUtils.checkNotNullAndNotEmpty(fsSeparator, "Missing file-system separator");
        if (GenericUtils.isEmpty(path) || Objects.equals(pathSeparator, fsSeparator)) {
            return path;
        }
        if (path.contains(fsSeparator)) {
            ValidateUtils.throwIllegalArgumentException("File system replacement may yield ambiguous result for %s with separator=%s", path, fsSeparator);
        }
        if (pathSeparator.length() == 1 && fsSeparator.length() == 1) {
            return path.replace(pathSeparator.charAt(0), fsSeparator.charAt(0));
        }
        return path.replace(pathSeparator, fsSeparator);
    }

    public static String concatPaths(String p1, String p2, char fsSeparator) {
        if (GenericUtils.isEmpty(p1)) {
            return p2;
        }
        if (GenericUtils.isEmpty(p2)) {
            return p1;
        }
        if (p1.charAt(p1.length() - 1) == fsSeparator) {
            if (p2.charAt(0) == fsSeparator) {
                return p2.length() == 1 ? p1 : p1 + p2.substring(1);
            }
            return p1 + p2;
        }
        if (p2.charAt(0) == fsSeparator) {
            return p2.length() == 1 ? p1 : p1 + p2;
        }
        return p1 + Character.toString(fsSeparator) + p2;
    }

    public static String removeWhitespace(String input) {
        StringBuilder result = new StringBuilder();
        if (input != null) {
            StringTokenizer st = new StringTokenizer(input);
            while (st.hasMoreTokens()) {
                result.append(st.nextToken());
            }
        }
        return result.toString();
    }
}

