/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.buffer.keys;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.keys.AbstractBufferPublicKeyParser;
import org.opendaylight.netconf.shaded.sshd.common.util.security.SecurityUtils;

public class ED25519BufferPublicKeyParser
extends AbstractBufferPublicKeyParser<PublicKey> {
    public static final ED25519BufferPublicKeyParser INSTANCE = new ED25519BufferPublicKeyParser();

    public ED25519BufferPublicKeyParser() {
        super(PublicKey.class, "ssh-ed25519");
    }

    @Override
    public PublicKey getRawPublicKey(String keyType, Buffer buffer) throws GeneralSecurityException {
        ValidateUtils.checkTrue(this.isKeyTypeSupported(keyType), "Unsupported key type: %s", (Object)keyType);
        byte[] seed = buffer.getBytes();
        return SecurityUtils.generateEDDSAPublicKey(keyType, seed);
    }
}

