/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.buffer.keys;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opendaylight.netconf.shaded.sshd.common.SshException;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.OpenSshCertificate;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.OpenSshCertificateImpl;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.ByteArrayBuffer;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.keys.AbstractBufferPublicKeyParser;

public class OpenSSHCertPublicKeyParser
extends AbstractBufferPublicKeyParser<OpenSshCertificate> {
    public static final List<String> KEY_TYPES = Collections.unmodifiableList(Arrays.asList("ssh-rsa-cert-v01@openssh.com", "ssh-dss-cert-v01@openssh.com", "ecdsa-sha2-nistp256-cert-v01@openssh.com", "ecdsa-sha2-nistp384-cert-v01@openssh.com", "ecdsa-sha2-nistp521-cert-v01@openssh.com", "ssh-ed25519-cert-v01@openssh.com"));
    public static final OpenSSHCertPublicKeyParser INSTANCE = new OpenSSHCertPublicKeyParser();

    public OpenSSHCertPublicKeyParser() {
        super(OpenSshCertificate.class, KEY_TYPES);
    }

    @Override
    public OpenSshCertificate getRawPublicKey(String keyType, Buffer buffer) throws GeneralSecurityException {
        OpenSshCertificateImpl certificate = new OpenSshCertificateImpl();
        certificate.setKeyType(keyType);
        certificate.setNonce(buffer.getBytes());
        String rawKeyType = certificate.getRawKeyType();
        Object certificatePublicKey = DEFAULT.getRawPublicKey(rawKeyType, buffer);
        certificate.setCertPubKey((PublicKey)certificatePublicKey);
        certificate.setSerial(buffer.getLong());
        certificate.setType(OpenSshCertificate.Type.fromCode(buffer.getInt()));
        certificate.setId(buffer.getString());
        Collection<String> principals = new ByteArrayBuffer(buffer.getBytes()).getStringList(false);
        certificate.setPrincipals(principals);
        certificate.setValidAfter(buffer.getLong());
        certificate.setValidBefore(buffer.getLong());
        certificate.setCriticalOptions(buffer.getCertificateOptions());
        certificate.setExtensions(buffer.getCertificateOptions());
        String reserved = GenericUtils.trimToEmpty(buffer.getString());
        certificate.setReserved(reserved.isEmpty() ? null : reserved);
        try {
            certificate.setCaPubKey(buffer.getPublicKey());
        }
        catch (SshException ex) {
            throw new InvalidKeyException("Could not parse public CA key with ID: " + certificate.getId(), ex);
        }
        certificate.setMessage(buffer.getBytesConsumed());
        certificate.setSignature(buffer.getBytes());
        if (buffer.rpos() != buffer.wpos()) {
            throw new InvalidKeyException("Cannot read OpenSSH certificate, got more data than expected: " + buffer.rpos() + ", actual: " + buffer.wpos() + ". ID of the ca certificate: " + certificate.getId());
        }
        return certificate;
    }
}

