/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.buffer.keys;

import java.security.GeneralSecurityException;
import java.security.interfaces.ECPublicKey;
import org.opendaylight.netconf.shaded.sshd.common.cipher.ECCurves;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.u2f.SkEcdsaPublicKey;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.keys.AbstractBufferPublicKeyParser;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.keys.ECBufferPublicKeyParser;

public class SkECBufferPublicKeyParser
extends AbstractBufferPublicKeyParser<SkEcdsaPublicKey> {
    public static final SkECBufferPublicKeyParser INSTANCE = new SkECBufferPublicKeyParser();

    public SkECBufferPublicKeyParser() {
        super(SkEcdsaPublicKey.class, "sk-ecdsa-sha2-nistp256@openssh.com");
    }

    @Override
    public SkEcdsaPublicKey getRawPublicKey(String keyType, Buffer buffer) throws GeneralSecurityException {
        ECPublicKey ecPublicKey = ECBufferPublicKeyParser.INSTANCE.getRawPublicKey(ECCurves.nistp256.getKeyType(), buffer);
        String appName = buffer.getString();
        return new SkEcdsaPublicKey(appName, false, ecPublicKey);
    }
}

