/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.closeable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.Closeable;
import org.opendaylight.netconf.shaded.sshd.common.future.SshFuture;
import org.opendaylight.netconf.shaded.sshd.common.util.ObjectBuilder;
import org.opendaylight.netconf.shaded.sshd.common.util.closeable.FuturesCloseable;
import org.opendaylight.netconf.shaded.sshd.common.util.closeable.ParallelCloseable;
import org.opendaylight.netconf.shaded.sshd.common.util.closeable.SequentialCloseable;
import org.opendaylight.netconf.shaded.sshd.common.util.closeable.SimpleCloseable;

public final class Builder
implements ObjectBuilder<Closeable> {
    private final Object lock;
    private final List<Closeable> closeables = new ArrayList<Closeable>();

    public Builder(Object lock) {
        this.lock = Objects.requireNonNull(lock, "No lock");
    }

    public Builder run(Object id, final Runnable r) {
        return this.close(new SimpleCloseable(id, this.lock){

            @Override
            protected void doClose(boolean immediately) {
                try {
                    r.run();
                }
                finally {
                    super.doClose(immediately);
                }
            }
        });
    }

    public <T extends SshFuture<T>> Builder when(SshFuture<T> future) {
        if (future != null) {
            this.when(future.getId(), Collections.singleton(future));
        }
        return this;
    }

    @SafeVarargs
    public final <T extends SshFuture<T>> Builder when(SshFuture<T> ... futures) {
        return this.when(this.getClass().getSimpleName(), Arrays.asList(futures));
    }

    public <T extends SshFuture<T>> Builder when(Object id, Iterable<? extends SshFuture<T>> futures) {
        return this.close(new FuturesCloseable(id, this.lock, futures));
    }

    public Builder sequential(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            this.close(closeable);
        }
        return this;
    }

    public Builder sequential(Object id, Iterable<Closeable> closeables) {
        return this.close(new SequentialCloseable(id, this.lock, closeables));
    }

    public Builder parallel(Closeable ... closeables) {
        if (closeables.length == 1) {
            this.close(closeables[0]);
        } else if (closeables.length > 0) {
            this.parallel(this.getClass().getSimpleName(), Arrays.asList(closeables));
        }
        return this;
    }

    public Builder parallel(Object id, Iterable<? extends Closeable> closeables) {
        return this.close(new ParallelCloseable(id, this.lock, closeables));
    }

    public Builder close(Closeable c) {
        if (c != null) {
            this.closeables.add(c);
        }
        return this;
    }

    @Override
    public Closeable build() {
        if (this.closeables.isEmpty()) {
            return new SimpleCloseable(this.getClass().getSimpleName(), this.lock);
        }
        if (this.closeables.size() == 1) {
            return this.closeables.get(0);
        }
        return new SequentialCloseable(this.getClass().getSimpleName(), this.lock, this.closeables);
    }
}

