/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.closeable;

import java.util.Collections;
import java.util.Iterator;
import org.opendaylight.netconf.shaded.sshd.common.Closeable;
import org.opendaylight.netconf.shaded.sshd.common.future.CloseFuture;
import org.opendaylight.netconf.shaded.sshd.common.future.SshFutureListener;
import org.opendaylight.netconf.shaded.sshd.common.util.closeable.SimpleCloseable;

public class SequentialCloseable
extends SimpleCloseable {
    private final Iterable<? extends Closeable> closeables;

    public SequentialCloseable(Object id, Object lock, Iterable<? extends Closeable> closeables) {
        super(id, lock);
        this.closeables = closeables == null ? Collections.emptyList() : closeables;
    }

    @Override
    protected void doClose(final boolean immediately) {
        final Iterator<? extends Closeable> iterator = this.closeables.iterator();
        SshFutureListener<CloseFuture> listener = new SshFutureListener<CloseFuture>(){

            @Override
            public void operationComplete(CloseFuture previousFuture) {
                boolean traceEnabled = SequentialCloseable.this.log.isTraceEnabled();
                while (iterator.hasNext()) {
                    Closeable c = (Closeable)iterator.next();
                    if (c == null) continue;
                    if (traceEnabled) {
                        SequentialCloseable.this.log.trace("doClose({}) closing {} immediately={}", new Object[]{this, c, immediately});
                    }
                    CloseFuture nextFuture = c.close(immediately);
                    nextFuture.addListener(this);
                    return;
                }
                if (!iterator.hasNext()) {
                    if (SequentialCloseable.this.log.isDebugEnabled()) {
                        SequentialCloseable.this.log.debug("doClose({}) signal close complete immediately={}", (Object)this, (Object)immediately);
                    }
                    SequentialCloseable.this.future.setClosed();
                }
            }
        };
        listener.operationComplete(null);
    }
}

