/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.helper;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LazyIterablesConcatenator<T>
implements Iterable<T> {
    private final Iterable<? extends Iterable<? extends T>> iterables;

    public LazyIterablesConcatenator(Iterable<? extends Iterable<? extends T>> iterables) {
        this.iterables = iterables;
    }

    public Iterable<? extends Iterable<? extends T>> getIterables() {
        return this.iterables;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<? extends Iterable<? extends T>> itit;
            private Iterator<? extends T> currentIterator;
            private boolean finished;
            {
                this.itit = LazyIterablesConcatenator.this.iterables == null ? Collections.emptyIterator() : LazyIterablesConcatenator.this.iterables.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.finished) {
                    return false;
                }
                if (this.currentIterator != null && this.currentIterator.hasNext()) {
                    return true;
                }
                while (this.itit.hasNext()) {
                    Iterable currentIterable = this.itit.next();
                    this.currentIterator = currentIterable.iterator();
                    if (!this.currentIterator.hasNext()) continue;
                    return true;
                }
                this.finished = true;
                return false;
            }

            @Override
            public T next() {
                if (this.finished) {
                    throw new NoSuchElementException("All elements have been exhausted");
                }
                if (this.currentIterator == null) {
                    throw new IllegalStateException("'next()' called without a preceding 'hasNext()' query");
                }
                return this.currentIterator.next();
            }

            public String toString() {
                return Iterator.class.getSimpleName() + "[lazy-concat]";
            }
        };
    }

    public String toString() {
        return Iterable.class.getSimpleName() + "[lazy-concat]";
    }

    public static <T> Iterable<T> lazyConcatenateIterables(Iterable<? extends Iterable<? extends T>> iterables) {
        return iterables == null ? Collections.emptyList() : new LazyIterablesConcatenator<T>(iterables);
    }
}

