/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.io;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.OsUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.functors.UnaryEquator;

public final class PathUtils {
    public static final Comparator<Path> BY_CASE_INSENSITIVE_FILENAME = (p1, p2) -> PathUtils.safeCompareFilename(p1, p2, false);
    public static final UnaryEquator<Path> EQ_CASE_INSENSITIVE_FILENAME = (p1, p2) -> BY_CASE_INSENSITIVE_FILENAME.compare((Path)p1, (Path)p2) == 0;
    public static final Comparator<Path> BY_CASE_SENSITIVE_FILENAME = (p1, p2) -> PathUtils.safeCompareFilename(p1, p2, true);
    public static final UnaryEquator<Path> EQ_CASE_SENSITIVE_FILENAME = (p1, p2) -> BY_CASE_SENSITIVE_FILENAME.compare((Path)p1, (Path)p2) == 0;
    public static final char HOME_TILDE_CHAR = '~';
    private static final AtomicReference<Supplier<? extends Path>> USER_HOME_RESOLVER_HOLDER = new AtomicReference();

    private PathUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static int safeCompareFilename(Path p1, Path p2, boolean caseSensitive) {
        if (UnaryEquator.isSameReference(p1, p2)) {
            return 0;
        }
        if (p1 == null) {
            return 1;
        }
        if (p2 == null) {
            return -1;
        }
        String n1 = Objects.toString(p1.getFileName(), null);
        String n2 = Objects.toString(p2.getFileName(), null);
        return GenericUtils.safeCompare(n1, n2, caseSensitive);
    }

    public static String normalizePath(String path) {
        if (GenericUtils.isBlank(path)) {
            return path;
        }
        if (path.charAt(0) == '~') {
            Path homeDir = Objects.requireNonNull(PathUtils.getUserHomeFolder(), "No user home folder available");
            path = path.length() > 1 ? homeDir + path.substring(1) : homeDir.toString();
        }
        return path.replace('/', File.separatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path getUserHomeFolder() {
        Supplier<? extends Path> resolver;
        AtomicReference<Supplier<? extends Path>> atomicReference = USER_HOME_RESOLVER_HOLDER;
        synchronized (atomicReference) {
            resolver = USER_HOME_RESOLVER_HOLDER.get();
        }
        return resolver == null ? LazyDefaultUserHomeFolderHolder.PATH : resolver.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserHomeFolderResolver(Supplier<? extends Path> resolver) {
        AtomicReference<Supplier<? extends Path>> atomicReference = USER_HOME_RESOLVER_HOLDER;
        synchronized (atomicReference) {
            USER_HOME_RESOLVER_HOLDER.set(resolver);
        }
    }

    public static StringBuilder appendUserHome(StringBuilder sb) {
        return PathUtils.appendUserHome(sb, PathUtils.getUserHomeFolder());
    }

    public static StringBuilder appendUserHome(StringBuilder sb, Path userHome) {
        return PathUtils.appendUserHome(sb, Objects.requireNonNull(userHome, "No user home folder").toString());
    }

    public static StringBuilder appendUserHome(StringBuilder sb, String userHome) {
        if (GenericUtils.isEmpty(userHome)) {
            return sb;
        }
        sb.append(userHome);
        int len = sb.length();
        if (sb.charAt(len - 1) == File.separatorChar) {
            sb.setLength(len - 1);
        }
        return sb;
    }

    private static final class LazyDefaultUserHomeFolderHolder {
        private static final Path PATH;

        private LazyDefaultUserHomeFolderHolder() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        static {
            String exceptionMessage = OsUtils.isAndroid() ? "No user home folder available. You should call org.apache.sshd.common.util.io.PathUtils.setUserHomeFolderResolver() method to set user home folder as there is no home folder on Android" : "No user home folder available";
            PATH = Paths.get(ValidateUtils.checkNotNullAndNotEmpty(System.getProperty("user.home"), exceptionMessage), new String[0]).toAbsolutePath().normalize();
        }
    }
}

