/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.io.der;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.NumberUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.BufferUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.io.der.ASN1Class;
import org.opendaylight.netconf.shaded.sshd.common.util.io.der.ASN1Type;
import org.opendaylight.netconf.shaded.sshd.common.util.io.der.DERParser;

public class ASN1Object
implements Serializable,
Cloneable {
    public static final byte CONSTRUCTED = 32;
    private static final long serialVersionUID = 4687581744706127265L;
    private ASN1Class objClass;
    private ASN1Type objType;
    private boolean constructed;
    private int length;
    private byte[] value;

    public ASN1Object() {
    }

    public ASN1Object(byte tag, int len, byte ... data) {
        this(ASN1Class.fromDERValue(tag), ASN1Type.fromDERValue(tag), (tag & 0x20) == 32, len, data);
    }

    public ASN1Object(ASN1Class c, ASN1Type t, boolean ctored, int len, byte ... data) {
        this.objClass = c;
        this.objType = t;
        this.constructed = ctored;
        this.length = len;
        this.value = data;
    }

    public ASN1Class getObjClass() {
        return this.objClass;
    }

    public void setObjClass(ASN1Class c) {
        this.objClass = c;
    }

    public ASN1Type getObjType() {
        return this.objType;
    }

    public void setObjType(ASN1Type y) {
        this.objType = y;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public void setConstructed(boolean c) {
        this.constructed = c;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int l) {
        this.length = l;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] getPureValueBytes() {
        byte[] bytes = this.getValue();
        int available = this.getLength();
        int numBytes = NumberUtils.length(bytes);
        if (numBytes == available) {
            return bytes;
        }
        if (available == 0) {
            return GenericUtils.EMPTY_BYTE_ARRAY;
        }
        byte[] pure = new byte[available];
        System.arraycopy(bytes, 0, pure, 0, available);
        return pure;
    }

    public void setValue(byte[] v) {
        this.value = v;
    }

    public DERParser createParser() {
        return new DERParser(this.getValue(), 0, this.getLength());
    }

    public Object asObject() throws IOException {
        ASN1Type type = this.getObjType();
        if (type == null) {
            throw new IOException("No type set");
        }
        switch (type) {
            case INTEGER: {
                return this.asInteger();
            }
            case NUMERIC_STRING: 
            case PRINTABLE_STRING: 
            case VIDEOTEX_STRING: 
            case IA5_STRING: 
            case GRAPHIC_STRING: 
            case ISO646_STRING: 
            case GENERAL_STRING: 
            case BMP_STRING: 
            case UTF8_STRING: {
                return this.asString();
            }
            case OBJECT_IDENTIFIER: {
                return this.asOID();
            }
            case SEQUENCE: {
                return this.getValue();
            }
        }
        throw new IOException("Invalid DER: unsupported type: " + (Object)((Object)type));
    }

    public BigInteger asInteger() throws IOException {
        ASN1Type typeValue = this.getObjType();
        if (ASN1Type.INTEGER.equals((Object)typeValue)) {
            return this.toInteger();
        }
        throw new IOException("Invalid DER: object is not integer: " + (Object)((Object)typeValue));
    }

    public BigInteger toInteger() {
        return new BigInteger(this.getPureValueBytes());
    }

    public String asString() throws IOException {
        String encoding;
        ASN1Type type = this.getObjType();
        if (type == null) {
            throw new IOException("No type set");
        }
        switch (type) {
            case NUMERIC_STRING: 
            case PRINTABLE_STRING: 
            case VIDEOTEX_STRING: 
            case IA5_STRING: 
            case GRAPHIC_STRING: 
            case ISO646_STRING: 
            case GENERAL_STRING: {
                encoding = "ISO-8859-1";
                break;
            }
            case BMP_STRING: {
                encoding = "UTF-16BE";
                break;
            }
            case UTF8_STRING: {
                encoding = "UTF-8";
                break;
            }
            case UNIVERSAL_STRING: {
                throw new IOException("Invalid DER: can't handle UCS-4 string");
            }
            default: {
                throw new IOException("Invalid DER: object is not a string: " + (Object)((Object)type));
            }
        }
        return new String(this.getValue(), 0, this.getLength(), encoding);
    }

    public List<Integer> asOID() throws IOException {
        ASN1Type typeValue = this.getObjType();
        if (ASN1Type.OBJECT_IDENTIFIER.equals((Object)typeValue)) {
            return this.toOID();
        }
        throw new StreamCorruptedException("Invalid DER: object is not an OID: " + (Object)((Object)typeValue));
    }

    public List<Integer> toOID() throws IOException {
        int vLen = this.getLength();
        if (vLen <= 0) {
            throw new EOFException("Not enough data for an OID");
        }
        ArrayList<Integer> oid = new ArrayList<Integer>(vLen + 1);
        byte[] bytes = this.getValue();
        int val1 = bytes[0] & 0xFF;
        oid.add(val1 / 40);
        oid.add(val1 % 40);
        for (int curPos = 1; curPos < vLen; ++curPos) {
            int v = bytes[curPos] & 0xFF;
            if (v <= 127) {
                oid.add(v);
                continue;
            }
            long curVal = v & 0x7F;
            ++curPos;
            int subLen = 1;
            while (true) {
                if (curPos >= vLen) {
                    throw new EOFException("Incomplete OID value");
                }
                if (subLen > 5) {
                    throw new StreamCorruptedException("OID component encoding beyond 5 bytes");
                }
                v = bytes[curPos] & 0xFF;
                if ((curVal = curVal << 7 & 0xFFFFFFFF80L | (long)v & 0x7FL) > Integer.MAX_VALUE) {
                    throw new StreamCorruptedException("OID value exceeds 32 bits: " + curVal);
                }
                if (v <= 127) break;
                ++subLen;
                ++curPos;
            }
            oid.add((int)(curVal & Integer.MAX_VALUE));
        }
        return oid;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getObjClass(), this.getObjType()}) + Boolean.hashCode(this.isConstructed()) + this.getLength() + NumberUtils.hashCode(this.getValue(), 0, this.getLength());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ASN1Object other = (ASN1Object)obj;
        return Objects.equals((Object)this.getObjClass(), (Object)other.getObjClass()) && Objects.equals((Object)this.getObjType(), (Object)other.getObjType()) && this.isConstructed() == other.isConstructed() && this.getLength() == other.getLength() && NumberUtils.diffOffset(this.getValue(), 0, other.getValue(), 0, this.getLength()) < 0;
    }

    public ASN1Object clone() {
        try {
            ASN1Object cpy = (ASN1Object)this.getClass().cast(super.clone());
            byte[] data = cpy.getValue();
            if (data != null) {
                cpy.setValue((byte[])data.clone());
            }
            return cpy;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException("Unexpected clone failure: " + e.getMessage(), e);
        }
    }

    public String toString() {
        return Objects.toString((Object)this.getObjClass()) + "/" + (Object)((Object)this.getObjType()) + "/" + this.isConstructed() + "[" + this.getLength() + "]: " + BufferUtils.toHex(this.getValue(), 0, this.getLength(), ':');
    }
}

