/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.io.der;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opendaylight.netconf.shaded.sshd.common.util.NumberUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.BufferUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.io.der.ASN1Class;
import org.opendaylight.netconf.shaded.sshd.common.util.io.der.ASN1Object;
import org.opendaylight.netconf.shaded.sshd.common.util.io.der.ASN1Type;

public class DERWriter
extends FilterOutputStream {
    private final byte[] lenBytes = new byte[4];

    public DERWriter() {
        this(256);
    }

    public DERWriter(int initialSize) {
        this(new ByteArrayOutputStream(initialSize));
    }

    public DERWriter(OutputStream stream) {
        super(Objects.requireNonNull(stream, "No output stream"));
    }

    public DERWriter startSequence() {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        final AtomicBoolean dataWritten = new AtomicBoolean(false);
        final DERWriter encloser = this;
        return new DERWriter(baos){

            @Override
            public void close() throws IOException {
                baos.close();
                if (!dataWritten.getAndSet(true)) {
                    encloser.writeObject(new ASN1Object(ASN1Class.UNIVERSAL, ASN1Type.SEQUENCE, false, baos.size(), baos.toByteArray()));
                }
            }
        };
    }

    public void writeBigInteger(BigInteger value) throws IOException {
        this.writeBigInteger(Objects.requireNonNull(value, "No value").toByteArray());
    }

    public void writeBigInteger(byte ... bytes) throws IOException {
        this.writeBigInteger(bytes, 0, NumberUtils.length(bytes));
    }

    public void writeBigInteger(byte[] bytes, int off, int len) throws IOException {
        while (len > 1 && bytes[off] == 0 && this.isPositive(bytes[off + 1])) {
            ++off;
            --len;
        }
        this.write(2);
        if (this.isPositive(bytes[off])) {
            this.writeLength(len);
        } else {
            this.writeLength(len + 1);
            this.write(0);
        }
        this.write(bytes, off, len);
    }

    private boolean isPositive(byte b) {
        return (b & 0x80) == 0;
    }

    public void writeObject(ASN1Object obj) throws IOException {
        Objects.requireNonNull(obj, "No ASN.1 object");
        ASN1Type type = obj.getObjType();
        byte typeValue = type.getTypeValue();
        ASN1Class clazz = obj.getObjClass();
        byte classValue = clazz.getClassValue();
        byte tagValue = (byte)(classValue << 6 & 0xC0 | typeValue & 0x1F);
        this.writeObject(tagValue, obj.getLength(), obj.getValue());
    }

    public void writeObject(byte tag, int len, byte ... data) throws IOException {
        this.write(tag & 0xFF);
        this.writeLength(len);
        this.write(data, 0, len);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void writeLength(int len) throws IOException {
        int nonZeroPos;
        ValidateUtils.checkTrue(len >= 0, "Invalid length: %d", len);
        if (len <= 127) {
            this.write(len);
            return;
        }
        BufferUtils.putUInt(len, this.lenBytes);
        for (nonZeroPos = 0; nonZeroPos < this.lenBytes.length && this.lenBytes[nonZeroPos] == 0; ++nonZeroPos) {
        }
        if (nonZeroPos >= this.lenBytes.length) {
            throw new StreamCorruptedException("All zeroes length representation for len=" + len);
        }
        int bytesLen = this.lenBytes.length - nonZeroPos;
        this.write(0x80 | bytesLen);
        this.write(this.lenBytes, nonZeroPos, bytesLen);
    }

    public byte[] toByteArray() throws IOException {
        if (this.out instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)this.out).toByteArray();
        }
        throw new IOException("The underlying stream is not a byte[] stream");
    }
}

