/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.io.output;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.io.output.LineLevelAppender;
import org.opendaylight.netconf.shaded.sshd.common.util.io.output.LineOutputStream;

public class LineLevelAppenderStream
extends LineOutputStream {
    protected final CharsetDecoder csDecoder;
    protected final LineLevelAppender appenderInstance;
    protected char[] lineBuf;

    public LineLevelAppenderStream(LineLevelAppender appender) {
        this(Charset.defaultCharset(), appender);
    }

    public LineLevelAppenderStream(String charset, LineLevelAppender appender) {
        this(Charset.forName(ValidateUtils.checkNotNullAndNotEmpty(charset, "No charset name")), appender);
    }

    public LineLevelAppenderStream(Charset charset, LineLevelAppender appender) {
        this(Objects.requireNonNull(charset, "No charset").newDecoder(), appender);
    }

    public LineLevelAppenderStream(CharsetDecoder decoder, LineLevelAppender appender) {
        this.csDecoder = Objects.requireNonNull(decoder, "No decoder");
        this.appenderInstance = Objects.requireNonNull(appender, "No appender");
    }

    public final LineLevelAppender getLineLevelAppender() {
        return this.appenderInstance;
    }

    @Override
    protected void handleLine(byte[] b, int off, int len) throws IOException {
        LineLevelAppender appender = this.getLineLevelAppender();
        if (len <= 0) {
            appender.writeLineData("");
            return;
        }
        ByteBuffer bb = b[off + len - 1] == 13 ? ByteBuffer.wrap(b, off, len - 1) : ByteBuffer.wrap(b, off, len);
        char[] lineChars = this.ensureCharDataCapacity(len);
        CharBuffer cc = CharBuffer.wrap(lineChars);
        this.csDecoder.reset();
        CoderResult res = this.csDecoder.decode(bb, cc, true);
        if (res.isError() || res.isMalformed() || res.isOverflow() || res.isUnmappable()) {
            throw new StreamCorruptedException("Failed to decode line bytes: " + res);
        }
        cc.flip();
        appender.writeLineData(cc);
    }

    protected char[] ensureCharDataCapacity(int numBytes) {
        int reqChars;
        float grwFactor = this.csDecoder.maxCharsPerByte();
        int n = reqChars = grwFactor > 0.0f ? (int)((float)numBytes * grwFactor) : numBytes;
        if (this.lineBuf == null || this.lineBuf.length < reqChars) {
            reqChars = Math.max(reqChars, 80);
            this.lineBuf = new char[reqChars + 8];
        }
        return this.lineBuf;
    }
}

