/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.io.output;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channel;
import java.util.concurrent.atomic.AtomicBoolean;

public class NullOutputStream
extends OutputStream
implements Channel {
    private final AtomicBoolean open = new AtomicBoolean(true);

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.isOpen()) {
            throw new EOFException("Stream is closed for writing one byte");
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.isOpen()) {
            throw new EOFException("Stream is closed for writing " + len + " bytes");
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.isOpen()) {
            throw new EOFException("Stream is closed for flushing");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            return;
        }
    }
}

