/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.io.resource;

import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.util.io.resource.IoResource;

public abstract class AbstractIoResource<T>
implements IoResource<T> {
    private final Class<T> resourceType;
    private final T resourceValue;

    protected AbstractIoResource(Class<T> resourceType, T resourceValue) {
        this.resourceType = Objects.requireNonNull(resourceType, "No resource type specified");
        this.resourceValue = Objects.requireNonNull(resourceValue, "No resource value provided");
    }

    @Override
    public Class<T> getResourceType() {
        return this.resourceType;
    }

    @Override
    public T getResourceValue() {
        return this.resourceValue;
    }

    @Override
    public String getName() {
        return Objects.toString(this.getResourceValue(), null);
    }

    public String toString() {
        return this.getName();
    }
}

