/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.io.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.io.resource.AbstractIoResource;
import org.opendaylight.netconf.shaded.sshd.common.util.threads.ThreadUtils;

public class ClassLoaderResource
extends AbstractIoResource<ClassLoader> {
    private final String resourceName;

    public ClassLoaderResource(ClassLoader loader, String resourceName) {
        super(ClassLoader.class, loader == null ? ThreadUtils.resolveDefaultClassLoader(ClassLoaderResource.class) : loader);
        this.resourceName = ValidateUtils.checkNotNullAndNotEmpty(resourceName, "No resource name provided");
    }

    public ClassLoader getResourceLoader() {
        return (ClassLoader)this.getResourceValue();
    }

    @Override
    public String getName() {
        return this.resourceName;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        String name = this.getName();
        ClassLoader cl = this.getResourceLoader();
        if (cl == null) {
            throw new StreamCorruptedException("No resource loader for " + name);
        }
        InputStream input = cl.getResourceAsStream(name);
        if (input == null) {
            throw new FileNotFoundException("Cannot find resource " + name);
        }
        return input;
    }
}

