/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.io.resource;

import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import org.opendaylight.netconf.shaded.sshd.common.NamedResource;
import org.opendaylight.netconf.shaded.sshd.common.util.io.resource.PathResource;
import org.opendaylight.netconf.shaded.sshd.common.util.io.resource.ResourceStreamProvider;
import org.opendaylight.netconf.shaded.sshd.common.util.io.resource.URIResource;
import org.opendaylight.netconf.shaded.sshd.common.util.io.resource.URLResource;

public interface IoResource<T>
extends NamedResource,
ResourceStreamProvider {
    public Class<T> getResourceType();

    public T getResourceValue();

    public static IoResource<?> forResource(Object resource) {
        if (resource == null) {
            return null;
        }
        if (resource instanceof Path) {
            return new PathResource((Path)resource);
        }
        if (resource instanceof URL) {
            return new URLResource((URL)resource);
        }
        if (resource instanceof URI) {
            return new URIResource((URI)resource);
        }
        throw new UnsupportedOperationException("Unsupported resource type " + resource.getClass().getSimpleName() + ": " + resource);
    }
}

