/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.io.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.opendaylight.netconf.shaded.sshd.common.util.io.IoUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.io.resource.AbstractIoResource;

public class PathResource
extends AbstractIoResource<Path> {
    private final OpenOption[] openOptions;

    public PathResource(Path path) {
        super(Path.class, path);
        this.openOptions = IoUtils.EMPTY_OPEN_OPTIONS;
    }

    public PathResource(Path path, OpenOption ... openOptions) {
        super(Path.class, path);
        this.openOptions = openOptions == null ? IoUtils.EMPTY_OPEN_OPTIONS : (OpenOption[])openOptions.clone();
    }

    public Path getPath() {
        return (Path)this.getResourceValue();
    }

    public OpenOption[] getOpenOptions() {
        return this.openOptions.length <= 0 ? this.openOptions : (OpenOption[])this.openOptions.clone();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return Files.newInputStream(this.getPath(), this.getOpenOptions());
    }
}

