/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opendaylight.netconf.shaded.sshd.common.auth.UserAuthFactoriesManager;
import org.opendaylight.netconf.shaded.sshd.common.keyprovider.HostKeyCertificateProvider;
import org.opendaylight.netconf.shaded.sshd.common.keyprovider.KeyPairProviderHolder;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.server.auth.BuiltinUserAuthFactories;
import org.opendaylight.netconf.shaded.sshd.server.auth.UserAuth;
import org.opendaylight.netconf.shaded.sshd.server.auth.UserAuthFactory;
import org.opendaylight.netconf.shaded.sshd.server.auth.gss.GSSAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.auth.gss.UserAuthGSSFactory;
import org.opendaylight.netconf.shaded.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.opendaylight.netconf.shaded.sshd.server.auth.password.PasswordAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.auth.password.UserAuthPasswordFactory;
import org.opendaylight.netconf.shaded.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.auth.pubkey.UserAuthPublicKeyFactory;
import org.opendaylight.netconf.shaded.sshd.server.session.ServerSession;

public interface ServerAuthenticationManager
extends UserAuthFactoriesManager<ServerSession, UserAuth, UserAuthFactory>,
KeyPairProviderHolder {
    public static final UserAuthPublicKeyFactory DEFAULT_USER_AUTH_PUBLIC_KEY_FACTORY = UserAuthPublicKeyFactory.INSTANCE;
    public static final UserAuthGSSFactory DEFAULT_USER_AUTH_GSS_FACTORY = UserAuthGSSFactory.INSTANCE;
    public static final UserAuthPasswordFactory DEFAULT_USER_AUTH_PASSWORD_FACTORY = UserAuthPasswordFactory.INSTANCE;
    public static final UserAuthKeyboardInteractiveFactory DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY = UserAuthKeyboardInteractiveFactory.INSTANCE;

    @Override
    default public void setUserAuthFactoriesNames(Collection<String> names) {
        BuiltinUserAuthFactories.ParseResult result = BuiltinUserAuthFactories.parseFactoriesList(names);
        List factories = ValidateUtils.checkNotNullAndNotEmpty(result.getParsedFactories(), "No supported cipher factories: %s", names);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(unsupported), "Unsupported cipher factories found: %s", unsupported);
        this.setUserAuthFactories(factories);
    }

    public PublickeyAuthenticator getPublickeyAuthenticator();

    public void setPasswordAuthenticator(PasswordAuthenticator var1);

    public PasswordAuthenticator getPasswordAuthenticator();

    public void setPublickeyAuthenticator(PublickeyAuthenticator var1);

    public KeyboardInteractiveAuthenticator getKeyboardInteractiveAuthenticator();

    public void setKeyboardInteractiveAuthenticator(KeyboardInteractiveAuthenticator var1);

    public GSSAuthenticator getGSSAuthenticator();

    public void setGSSAuthenticator(GSSAuthenticator var1);

    public HostBasedAuthenticator getHostBasedAuthenticator();

    public void setHostBasedAuthenticator(HostBasedAuthenticator var1);

    public HostKeyCertificateProvider getHostKeyCertificateProvider();

    public void setHostKeyCertificateProvider(HostKeyCertificateProvider var1);

    public static List<UserAuthFactory> resolveUserAuthFactories(ServerAuthenticationManager manager) {
        if (manager == null) {
            return Collections.emptyList();
        }
        return ServerAuthenticationManager.resolveUserAuthFactories(manager, manager.getUserAuthFactories());
    }

    public static List<UserAuthFactory> resolveUserAuthFactories(ServerAuthenticationManager manager, List<UserAuthFactory> userFactories) {
        if (GenericUtils.size(userFactories) > 0) {
            return userFactories;
        }
        if (manager == null) {
            return Collections.emptyList();
        }
        ArrayList<UserAuthFactory> factories = new ArrayList<UserAuthFactory>();
        if (manager.getPasswordAuthenticator() != null) {
            factories.add(DEFAULT_USER_AUTH_PASSWORD_FACTORY);
            factories.add(DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY);
        } else if (manager.getKeyboardInteractiveAuthenticator() != null) {
            factories.add(DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY);
        }
        if (manager.getPublickeyAuthenticator() != null) {
            factories.add(DEFAULT_USER_AUTH_PUBLIC_KEY_FACTORY);
        }
        if (manager.getGSSAuthenticator() != null) {
            factories.add(DEFAULT_USER_AUTH_GSS_FACTORY);
        }
        return factories;
    }
}

