/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.opendaylight.netconf.shaded.sshd.common.BaseBuilder;
import org.opendaylight.netconf.shaded.sshd.common.BuiltinFactory;
import org.opendaylight.netconf.shaded.sshd.common.NamedFactory;
import org.opendaylight.netconf.shaded.sshd.common.channel.ChannelFactory;
import org.opendaylight.netconf.shaded.sshd.common.channel.RequestHandler;
import org.opendaylight.netconf.shaded.sshd.common.cipher.BuiltinCiphers;
import org.opendaylight.netconf.shaded.sshd.common.compression.BuiltinCompressions;
import org.opendaylight.netconf.shaded.sshd.common.compression.Compression;
import org.opendaylight.netconf.shaded.sshd.common.compression.CompressionFactory;
import org.opendaylight.netconf.shaded.sshd.common.global.KeepAliveHandler;
import org.opendaylight.netconf.shaded.sshd.common.kex.DHFactory;
import org.opendaylight.netconf.shaded.sshd.common.kex.KeyExchangeFactory;
import org.opendaylight.netconf.shaded.sshd.common.kex.extension.DefaultServerKexExtensionHandler;
import org.opendaylight.netconf.shaded.sshd.common.kex.extension.KexExtensionHandler;
import org.opendaylight.netconf.shaded.sshd.common.session.ConnectionService;
import org.opendaylight.netconf.shaded.sshd.common.signature.Signature;
import org.opendaylight.netconf.shaded.sshd.server.SshServer;
import org.opendaylight.netconf.shaded.sshd.server.auth.keyboard.DefaultKeyboardInteractiveAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.channel.ChannelSessionFactory;
import org.opendaylight.netconf.shaded.sshd.server.config.keys.DefaultAuthorizedKeysAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.forward.DirectTcpipFactory;
import org.opendaylight.netconf.shaded.sshd.server.global.CancelTcpipForwardHandler;
import org.opendaylight.netconf.shaded.sshd.server.global.NoMoreSessionsHandler;
import org.opendaylight.netconf.shaded.sshd.server.global.OpenSshHostKeysHandler;
import org.opendaylight.netconf.shaded.sshd.server.global.TcpipForwardHandler;
import org.opendaylight.netconf.shaded.sshd.server.kex.DHGEXServer;
import org.opendaylight.netconf.shaded.sshd.server.kex.DHGServer;

public class ServerBuilder
extends BaseBuilder<SshServer, ServerBuilder> {
    public static final Function<DHFactory, KeyExchangeFactory> DH2KEX = factory -> factory == null ? null : (factory.isGroupExchange() ? DHGEXServer.newFactory(factory) : DHGServer.newFactory(factory));
    public static final List<ChannelFactory> DEFAULT_CHANNEL_FACTORIES = Collections.unmodifiableList(Arrays.asList(ChannelSessionFactory.INSTANCE, DirectTcpipFactory.INSTANCE));
    public static final List<RequestHandler<ConnectionService>> DEFAULT_GLOBAL_REQUEST_HANDLERS = Collections.unmodifiableList(Arrays.asList(KeepAliveHandler.INSTANCE, NoMoreSessionsHandler.INSTANCE, TcpipForwardHandler.INSTANCE, CancelTcpipForwardHandler.INSTANCE, OpenSshHostKeysHandler.INSTANCE));
    public static final PublickeyAuthenticator DEFAULT_PUBLIC_KEY_AUTHENTICATOR = DefaultAuthorizedKeysAuthenticator.INSTANCE;
    public static final KeyboardInteractiveAuthenticator DEFAULT_INTERACTIVE_AUTHENTICATOR = DefaultKeyboardInteractiveAuthenticator.INSTANCE;
    public static final List<CompressionFactory> DEFAULT_COMPRESSION_FACTORIES = Collections.unmodifiableList(Arrays.asList(BuiltinCompressions.none, BuiltinCompressions.zlib, BuiltinCompressions.delayedZlib));
    public static final KexExtensionHandler DEFAULT_KEX_EXTENSION_HANDLER = DefaultServerKexExtensionHandler.INSTANCE;
    public static final List<BuiltinCiphers> DEFAULT_SERVER_CIPHERS_PREFERENCE = Collections.unmodifiableList(Arrays.asList(BuiltinCiphers.cc20p1305_openssh, BuiltinCiphers.aes128ctr, BuiltinCiphers.aes192ctr, BuiltinCiphers.aes256ctr, BuiltinCiphers.aes128gcm, BuiltinCiphers.aes256gcm));
    protected PublickeyAuthenticator pubkeyAuthenticator;
    protected KeyboardInteractiveAuthenticator interactiveAuthenticator;

    public ServerBuilder interactiveAuthenticator(KeyboardInteractiveAuthenticator auth) {
        this.interactiveAuthenticator = auth;
        return this;
    }

    public ServerBuilder publickeyAuthenticator(PublickeyAuthenticator auth) {
        this.pubkeyAuthenticator = auth;
        return this;
    }

    @Override
    protected ServerBuilder fillWithDefaultValues() {
        if (this.cipherFactories == null) {
            this.cipherFactories(BuiltinFactory.setUpFactories(false, DEFAULT_SERVER_CIPHERS_PREFERENCE));
        }
        super.fillWithDefaultValues();
        if (this.compressionFactories == null) {
            this.compressionFactories = ServerBuilder.setUpDefaultCompressionFactories(true);
        }
        if (this.signatureFactories == null) {
            this.signatureFactories = ServerBuilder.setUpDefaultSignatureFactories(true);
        }
        if (this.keyExchangeFactories == null) {
            this.keyExchangeFactories = ServerBuilder.setUpDefaultKeyExchanges(true);
        }
        if (this.kexExtensionHandler == null) {
            this.kexExtensionHandler = DEFAULT_KEX_EXTENSION_HANDLER;
        }
        if (this.channelFactories == null) {
            this.channelFactories = DEFAULT_CHANNEL_FACTORIES;
        }
        if (this.globalRequestHandlers == null) {
            this.globalRequestHandlers = DEFAULT_GLOBAL_REQUEST_HANDLERS;
        }
        if (this.pubkeyAuthenticator == null) {
            this.pubkeyAuthenticator = DEFAULT_PUBLIC_KEY_AUTHENTICATOR;
        }
        if (this.interactiveAuthenticator == null) {
            this.interactiveAuthenticator = DEFAULT_INTERACTIVE_AUTHENTICATOR;
        }
        if (this.factory == null) {
            this.factory = SshServer.DEFAULT_SSH_SERVER_FACTORY;
        }
        return (ServerBuilder)this.me();
    }

    @Override
    public SshServer build(boolean isFillWithDefaultValues) {
        SshServer server = (SshServer)super.build(isFillWithDefaultValues);
        server.setPublickeyAuthenticator(this.pubkeyAuthenticator);
        server.setKeyboardInteractiveAuthenticator(this.interactiveAuthenticator);
        return server;
    }

    public static List<NamedFactory<Signature>> setUpDefaultSignatureFactories(boolean ignoreUnsupported) {
        return NamedFactory.setUpBuiltinFactories(ignoreUnsupported, DEFAULT_SIGNATURE_PREFERENCE);
    }

    public static List<NamedFactory<Compression>> setUpDefaultCompressionFactories(boolean ignoreUnsupported) {
        return NamedFactory.setUpBuiltinFactories(ignoreUnsupported, DEFAULT_COMPRESSION_FACTORIES);
    }

    public static List<KeyExchangeFactory> setUpDefaultKeyExchanges(boolean ignoreUnsupported) {
        return NamedFactory.setUpTransformedFactories(ignoreUnsupported, DEFAULT_KEX_PREFERENCE, DH2KEX);
    }

    public static ServerBuilder builder() {
        return new ServerBuilder();
    }
}

