/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.server.auth;

import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.common.util.logging.AbstractLoggingBean;
import org.opendaylight.netconf.shaded.sshd.server.auth.UserAuth;
import org.opendaylight.netconf.shaded.sshd.server.session.ServerSession;

public abstract class AbstractUserAuth
extends AbstractLoggingBean
implements UserAuth {
    private final String name;
    private ServerSession session;
    private String service;
    private String username;

    protected AbstractUserAuth(String name) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(name, "No name");
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public String getService() {
        return this.service;
    }

    @Override
    public ServerSession getServerSession() {
        return this.session;
    }

    @Override
    public ServerSession getSession() {
        return this.getServerSession();
    }

    @Override
    public Boolean auth(ServerSession session, String username, String service, Buffer buffer) throws Exception {
        this.session = Objects.requireNonNull(session, "No server session");
        this.username = username;
        this.service = service;
        return this.doAuth(buffer, true);
    }

    @Override
    public Boolean next(Buffer buffer) throws Exception {
        return this.doAuth(buffer, false);
    }

    @Override
    public void destroy() {
    }

    protected abstract Boolean doAuth(Buffer var1, boolean var2) throws Exception;

    public String toString() {
        return this.getName() + ": " + this.getSession() + "[" + this.getService() + "]";
    }
}

