/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.server.auth.hostbased;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.KeyUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.logging.AbstractLoggingBean;
import org.opendaylight.netconf.shaded.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.session.ServerSession;

public class StaticHostBasedAuthenticator
extends AbstractLoggingBean
implements HostBasedAuthenticator {
    private final boolean acceptance;

    public StaticHostBasedAuthenticator(boolean acceptance) {
        this.acceptance = acceptance;
    }

    public final boolean isAccepted() {
        return this.acceptance;
    }

    @Override
    public final boolean authenticate(ServerSession session, String username, PublicKey clientHostKey, String clientHostName, String clientUsername, List<X509Certificate> certificates) {
        boolean accepted = this.isAccepted();
        if (accepted) {
            this.handleAcceptance(session, username, clientHostKey, clientHostName, clientUsername, certificates);
        } else {
            this.handleRejection(session, username, clientHostKey, clientHostName, clientUsername, certificates);
        }
        return accepted;
    }

    protected void handleAcceptance(ServerSession session, String username, PublicKey clientHostKey, String clientHostName, String clientUsername, List<X509Certificate> certificates) {
        this.log.warn("authenticate({}[{}]: accepted without checking {}@{} key={} fingerprint={}", new Object[]{username, session, clientUsername, clientHostName, KeyUtils.getKeyType(clientHostKey), KeyUtils.getFingerPrint(clientHostKey)});
    }

    protected void handleRejection(ServerSession session, String username, PublicKey clientHostKey, String clientHostName, String clientUsername, List<X509Certificate> certificates) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({}[{}]: rejected {}@{} key={} fingerprint={}", new Object[]{username, session, clientUsername, clientHostName, KeyUtils.getKeyType(clientHostKey), KeyUtils.getFingerPrint(clientHostKey)});
        }
    }
}

