/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.server.auth.pubkey;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Collection;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.AuthorizedKeyEntry;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.PublicKeyEntryResolver;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.server.auth.AsyncAuthException;
import org.opendaylight.netconf.shaded.sshd.server.auth.pubkey.AuthorizedKeyEntriesPublickeyAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.auth.pubkey.RejectAllPublickeyAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.session.ServerSession;

@FunctionalInterface
public interface PublickeyAuthenticator {
    public boolean authenticate(String var1, PublicKey var2, ServerSession var3) throws AsyncAuthException;

    public static PublickeyAuthenticator fromAuthorizedEntries(Object id, ServerSession session, Collection<? extends AuthorizedKeyEntry> entries, PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException {
        if (GenericUtils.isEmpty(entries)) {
            return RejectAllPublickeyAuthenticator.INSTANCE;
        }
        return new AuthorizedKeyEntriesPublickeyAuthenticator(id, session, entries, fallbackResolver);
    }
}

