/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.server.forward;

import org.opendaylight.netconf.shaded.sshd.common.session.Session;
import org.opendaylight.netconf.shaded.sshd.common.util.net.SshdSocketAddress;
import org.opendaylight.netconf.shaded.sshd.server.forward.AgentForwardingFilter;
import org.opendaylight.netconf.shaded.sshd.server.forward.RejectAllForwardingFilter;
import org.opendaylight.netconf.shaded.sshd.server.forward.TcpForwardingFilter;
import org.opendaylight.netconf.shaded.sshd.server.forward.X11ForwardingFilter;

public interface ForwardingFilter
extends AgentForwardingFilter,
X11ForwardingFilter,
TcpForwardingFilter {
    public static ForwardingFilter asForwardingFilter(final AgentForwardingFilter agentFilter, final X11ForwardingFilter x11Filter, final TcpForwardingFilter tcpFilter) {
        if (agentFilter == null && x11Filter == null && tcpFilter == null) {
            return RejectAllForwardingFilter.INSTANCE;
        }
        return new ForwardingFilter(){

            @Override
            public boolean canForwardAgent(Session session, String requestType) {
                return agentFilter != null && agentFilter.canForwardAgent(session, requestType);
            }

            @Override
            public boolean canForwardX11(Session session, String requestType) {
                return x11Filter != null && x11Filter.canForwardX11(session, requestType);
            }

            @Override
            public boolean canListen(SshdSocketAddress address, Session session) {
                return tcpFilter != null && tcpFilter.canListen(address, session);
            }

            @Override
            public boolean canConnect(TcpForwardingFilter.Type type, SshdSocketAddress address, Session session) {
                return tcpFilter != null && tcpFilter.canConnect(type, address, session);
            }
        };
    }
}

