/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.server.global;

import java.util.Objects;
import java.util.function.IntUnaryOperator;
import org.opendaylight.netconf.shaded.sshd.common.channel.RequestHandler;
import org.opendaylight.netconf.shaded.sshd.common.forward.Forwarder;
import org.opendaylight.netconf.shaded.sshd.common.session.ConnectionService;
import org.opendaylight.netconf.shaded.sshd.common.session.helpers.AbstractConnectionServiceRequestHandler;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.common.util.functors.Int2IntFunction;
import org.opendaylight.netconf.shaded.sshd.common.util.net.SshdSocketAddress;

public class CancelTcpipForwardHandler
extends AbstractConnectionServiceRequestHandler {
    public static final String REQUEST = "cancel-tcpip-forward";
    public static final IntUnaryOperator RESPONSE_BUFFER_GROWTH_FACTOR = Int2IntFunction.add(8);
    public static final CancelTcpipForwardHandler INSTANCE = new CancelTcpipForwardHandler();

    @Override
    public RequestHandler.Result process(ConnectionService connectionService, String request, boolean wantReply, Buffer buffer) throws Exception {
        if (!REQUEST.equals(request)) {
            return super.process(connectionService, request, wantReply, buffer);
        }
        String address = buffer.getString();
        int port = buffer.getInt();
        SshdSocketAddress socketAddress = new SshdSocketAddress(address, port);
        if (this.log.isDebugEnabled()) {
            this.log.debug("process({})[{}] {} reply={}", new Object[]{connectionService, request, socketAddress, wantReply});
        }
        Forwarder forwarder = Objects.requireNonNull(connectionService.getForwarder(), "No TCP/IP forwarder");
        forwarder.localPortForwardingCancelled(socketAddress);
        if (wantReply) {
            Object session = connectionService.getSession();
            buffer = session.createBuffer((byte)81, 4);
            buffer.putUInt(port);
            session.writePacket(buffer);
        }
        return RequestHandler.Result.Replied;
    }
}

