/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.server.global;

import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.NamedFactory;
import org.opendaylight.netconf.shaded.sshd.common.NamedResource;
import org.opendaylight.netconf.shaded.sshd.common.RuntimeSshException;
import org.opendaylight.netconf.shaded.sshd.common.channel.RequestHandler;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.KeyUtils;
import org.opendaylight.netconf.shaded.sshd.common.global.AbstractOpenSshHostKeysHandler;
import org.opendaylight.netconf.shaded.sshd.common.keyprovider.KeyPairProvider;
import org.opendaylight.netconf.shaded.sshd.common.session.Session;
import org.opendaylight.netconf.shaded.sshd.common.signature.Signature;
import org.opendaylight.netconf.shaded.sshd.common.signature.SignatureFactoriesManager;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.ByteArrayBuffer;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.keys.BufferPublicKeyParser;
import org.opendaylight.netconf.shaded.sshd.server.session.ServerSession;

public class OpenSshHostKeysHandler
extends AbstractOpenSshHostKeysHandler
implements SignatureFactoriesManager {
    public static final String REQUEST = "hostkeys-prove-00@openssh.com";
    public static final OpenSshHostKeysHandler INSTANCE = new OpenSshHostKeysHandler(){

        @Override
        public List<NamedFactory<Signature>> getSignatureFactories() {
            return null;
        }

        @Override
        public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
            if (!GenericUtils.isEmpty(factories)) {
                throw new UnsupportedOperationException("Not allowed to change default instance signature factories");
            }
        }
    };
    private List<NamedFactory<Signature>> factories;

    public OpenSshHostKeysHandler() {
        super(REQUEST);
    }

    public OpenSshHostKeysHandler(BufferPublicKeyParser<? extends PublicKey> parser) {
        super(REQUEST, parser);
    }

    @Override
    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.factories;
    }

    @Override
    public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
        this.factories = factories;
    }

    @Override
    protected RequestHandler.Result handleHostKeys(Session session, Collection<? extends PublicKey> keys, boolean wantReply, Buffer buffer) throws Exception {
        ValidateUtils.checkTrue(wantReply, "No reply required for host keys of %s", (Object)session);
        List<NamedFactory<Signature>> factories = ValidateUtils.checkNotNullAndNotEmpty(SignatureFactoriesManager.resolveSignatureFactories(this, session), "No signature factories available for host keys of session=%s", session);
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleHostKeys({})[want-reply={}] received {} keys - factories={}", new Object[]{session, wantReply, GenericUtils.size(keys), NamedResource.getNames(factories)});
        }
        buffer = session.createBuffer((byte)81);
        ByteArrayBuffer buf = new ByteArrayBuffer();
        byte[] sessionId = session.getSessionId();
        KeyPairProvider kpp = Objects.requireNonNull(((ServerSession)session).getKeyPairProvider(), "No server keys provider");
        for (PublicKey publicKey : keys) {
            KeyPair kp;
            String keyType = KeyUtils.getKeyType(publicKey);
            Signature verifier = ValidateUtils.checkNotNull(NamedFactory.create(factories, keyType), "No signer could be located for key type=%s", (Object)keyType);
            try {
                kp = ValidateUtils.checkNotNull(kpp.loadKey(session, keyType), "No key of type=%s available", (Object)keyType);
            }
            catch (Error e) {
                this.warn("handleHostKeys({}) failed ({}) to load key of type={}: {}", session, e.getClass().getSimpleName(), keyType, e.getMessage(), e);
                throw new RuntimeSshException(e);
            }
            verifier.initSigner(session, kp.getPrivate());
            buf.clear();
            buf.putString(REQUEST);
            buf.putBytes(sessionId);
            buf.putPublicKey(publicKey);
            byte[] data = buf.getCompactData();
            verifier.update(session, data);
            byte[] signature = verifier.sign(session);
            buffer.putBytes(signature);
        }
        session.writePacket(buffer);
        return RequestHandler.Result.Replied;
    }
}

