/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.server.kex;

import java.security.KeyPair;
import java.util.Arrays;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.NamedFactory;
import org.opendaylight.netconf.shaded.sshd.common.SshException;
import org.opendaylight.netconf.shaded.sshd.common.digest.Digest;
import org.opendaylight.netconf.shaded.sshd.common.kex.AbstractDH;
import org.opendaylight.netconf.shaded.sshd.common.kex.DHFactory;
import org.opendaylight.netconf.shaded.sshd.common.kex.KexProposalOption;
import org.opendaylight.netconf.shaded.sshd.common.kex.KeyEncapsulationMethod;
import org.opendaylight.netconf.shaded.sshd.common.kex.KeyExchange;
import org.opendaylight.netconf.shaded.sshd.common.kex.KeyExchangeFactory;
import org.opendaylight.netconf.shaded.sshd.common.kex.XDH;
import org.opendaylight.netconf.shaded.sshd.common.session.Session;
import org.opendaylight.netconf.shaded.sshd.common.signature.Signature;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.BufferUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.ByteArrayBuffer;
import org.opendaylight.netconf.shaded.sshd.server.kex.AbstractDHServerKeyExchange;
import org.opendaylight.netconf.shaded.sshd.server.session.ServerSession;

public class DHGServer
extends AbstractDHServerKeyExchange {
    protected final DHFactory factory;
    protected AbstractDH dh;

    protected DHGServer(DHFactory factory, Session session) {
        super(session);
        this.factory = Objects.requireNonNull(factory, "No factory");
    }

    @Override
    public final String getName() {
        return this.factory.getName();
    }

    public static KeyExchangeFactory newFactory(final DHFactory factory) {
        return new KeyExchangeFactory(){

            @Override
            public KeyExchange createKeyExchange(Session session) throws Exception {
                return new DHGServer(factory, session);
            }

            @Override
            public String getName() {
                return factory.getName();
            }

            public String toString() {
                return NamedFactory.class.getSimpleName() + "<" + KeyExchange.class.getSimpleName() + ">[" + this.getName() + "]";
            }
        };
    }

    @Override
    public void init(byte[] v_s, byte[] v_c, byte[] i_s, byte[] i_c) throws Exception {
        super.init(v_s, v_c, i_s, i_c);
        this.dh = this.factory.create(new Object[0]);
        this.hash = this.dh.getHash();
        this.hash.init();
        this.setF(this.dh.getE());
    }

    @Override
    public boolean next(int cmd, Buffer buffer) throws Exception {
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("next({})[{}] process command={}", new Object[]{this, session, KeyExchange.getSimpleKexOpcodeName(cmd)});
        }
        if (cmd != 30) {
            throw new SshException(3, "Protocol error: expected packet SSH_MSG_KEXDH_INIT, got " + KeyExchange.getSimpleKexOpcodeName(cmd));
        }
        byte[] e = this.updateE(buffer);
        KeyEncapsulationMethod kem = this.dh.getKeyEncapsulation();
        if (kem == null) {
            this.dh.setF(e);
            this.k = this.normalize(this.dh.getK());
        } else {
            try {
                KeyEncapsulationMethod.Server kemServer = kem.getServer();
                byte[] f = kemServer.init(e);
                if (this.dh instanceof XDH) {
                    if (f.length != ((XDH)this.dh).getKeySize()) {
                        throw new SshException(3, "Wrong E length (should be 1190 bytes): " + e.length);
                    }
                } else {
                    throw new SshException(3, "Key encapsulation only supported for XDH");
                }
                this.dh.setF(f);
                byte[] dhK = this.dh.getK();
                Digest keyHash = this.dh.getHash();
                keyHash.init();
                keyHash.update(kemServer.getSecret());
                keyHash.update(dhK);
                this.k = keyHash.digest();
                byte[] newF = kemServer.getEncapsulation();
                int l = newF.length;
                newF = Arrays.copyOf(newF, l + this.dh.getE().length);
                System.arraycopy(this.dh.getE(), 0, newF, l, this.dh.getE().length);
                this.setF(newF);
            }
            catch (IllegalArgumentException ex) {
                throw new SshException(3, "Key encapsulation error: " + ex.getMessage());
            }
        }
        KeyPair kp = Objects.requireNonNull(session.getHostKey(), "No server key pair available");
        String algo = session.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS);
        Signature sig = ValidateUtils.checkNotNull(NamedFactory.create(session.getSignatureFactories(), algo), "Unknown negotiated server keys: %s", (Object)algo);
        sig.initSigner(session, kp.getPrivate());
        buffer = new ByteArrayBuffer();
        buffer.putRawPublicKey(kp.getPublic());
        byte[] k_s = buffer.getCompactData();
        buffer.clear();
        buffer.putBytes(this.v_c);
        buffer.putBytes(this.v_s);
        buffer.putBytes(this.i_c);
        buffer.putBytes(this.i_s);
        buffer.putBytes(k_s);
        this.dh.putE(buffer, e);
        byte[] f = this.getF();
        this.dh.putF(buffer, f);
        buffer.putBytes(this.k);
        this.hash.update(buffer.array(), 0, buffer.available());
        this.h = this.hash.digest();
        sig.update(session, this.h);
        buffer.clear();
        buffer.putString(sig.getSshAlgorithmName(algo));
        byte[] sigBytes = sig.sign(session);
        buffer.putBytes(sigBytes);
        byte[] sigH = buffer.getCompactData();
        if (this.log.isTraceEnabled()) {
            this.log.trace("next({})[{}][K_S]:  {}", new Object[]{this, session, BufferUtils.toHex(k_s)});
            this.log.trace("next({})[{}][f]:    {}", new Object[]{this, session, BufferUtils.toHex(f)});
            this.log.trace("next({})[{}][sigH]: {}", new Object[]{this, session, BufferUtils.toHex(sigH)});
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("next({})[{}] Send SSH_MSG_KEXDH_REPLY", (Object)this, (Object)session);
        }
        buffer = session.prepareBuffer((byte)31, BufferUtils.clear(buffer));
        buffer.putBytes(k_s);
        this.dh.putF(buffer, f);
        buffer.putBytes(sigH);
        session.writePacket(buffer);
        return true;
    }
}

