/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.eddsa.math.bigint;

import java.math.BigInteger;
import org.opendaylight.netconf.shaded.eddsa.math.Field;
import org.opendaylight.netconf.shaded.eddsa.math.ScalarOps;
import org.opendaylight.netconf.shaded.eddsa.math.bigint.BigIntegerLittleEndianEncoding;

public class BigIntegerScalarOps
implements ScalarOps {
    private final BigInteger l;
    private final BigIntegerLittleEndianEncoding enc;

    public BigIntegerScalarOps(Field f, BigInteger l) {
        this.l = l;
        this.enc = new BigIntegerLittleEndianEncoding();
        this.enc.setField(f);
    }

    @Override
    public byte[] reduce(byte[] s) {
        return this.enc.encode(this.enc.toBigInteger(s).mod(this.l));
    }

    @Override
    public byte[] multiplyAndAdd(byte[] a, byte[] b, byte[] c) {
        return this.enc.encode(this.enc.toBigInteger(a).multiply(this.enc.toBigInteger(b)).add(this.enc.toBigInteger(c)).mod(this.l));
    }
}

