/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.agent.unix;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opendaylight.netconf.shaded.sshd.agent.SshAgent;
import org.opendaylight.netconf.shaded.sshd.agent.SshAgentFactory;
import org.opendaylight.netconf.shaded.sshd.agent.SshAgentServer;
import org.opendaylight.netconf.shaded.sshd.agent.unix.AgentClient;
import org.opendaylight.netconf.shaded.sshd.agent.unix.AgentServerProxy;
import org.opendaylight.netconf.shaded.sshd.agent.unix.ChannelAgentForwardingFactory;
import org.opendaylight.netconf.shaded.sshd.common.Factory;
import org.opendaylight.netconf.shaded.sshd.common.FactoryManager;
import org.opendaylight.netconf.shaded.sshd.common.SshException;
import org.opendaylight.netconf.shaded.sshd.common.channel.ChannelFactory;
import org.opendaylight.netconf.shaded.sshd.common.session.ConnectionService;
import org.opendaylight.netconf.shaded.sshd.common.session.Session;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.threads.CloseableExecutorService;
import org.opendaylight.netconf.shaded.sshd.server.session.ServerSession;

public class UnixAgentFactory
implements SshAgentFactory {
    public static final List<ChannelFactory> DEFAULT_FORWARDING_CHANNELS = Collections.unmodifiableList(Arrays.asList(ChannelAgentForwardingFactory.OPENSSH, ChannelAgentForwardingFactory.IETF));
    private Factory<CloseableExecutorService> executorServiceFactory;

    public UnixAgentFactory() {
    }

    public UnixAgentFactory(Factory<CloseableExecutorService> factory) {
        this.executorServiceFactory = factory;
    }

    protected CloseableExecutorService newExecutor() {
        return this.executorServiceFactory != null ? this.executorServiceFactory.create() : null;
    }

    @Override
    public List<ChannelFactory> getChannelForwardingFactories(FactoryManager manager) {
        if (this.executorServiceFactory != null) {
            return DEFAULT_FORWARDING_CHANNELS.stream().map(cf -> new ChannelAgentForwardingFactory(cf.getName(), this.executorServiceFactory)).collect(Collectors.toList());
        }
        return DEFAULT_FORWARDING_CHANNELS;
    }

    @Override
    public SshAgent createClient(Session session, FactoryManager manager) throws IOException {
        String authSocket = manager.getString("SSH_AUTH_SOCK");
        if (GenericUtils.isEmpty(authSocket)) {
            throw new SshException("No SSH_AUTH_SOCK value");
        }
        return new AgentClient(manager, authSocket, this.newExecutor());
    }

    @Override
    public SshAgentServer createServer(ConnectionService service) throws IOException {
        Session session = (Session)Objects.requireNonNull(service.getSession(), "No session");
        ValidateUtils.checkInstanceOf((Object)session, ServerSession.class, "The session used to create an agent server proxy must be a server session: %s", (Object)session);
        return new AgentServerProxy(service, this.newExecutor());
    }
}

