/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.client;

import java.security.KeyPair;
import java.util.Collection;
import java.util.List;
import org.opendaylight.netconf.shaded.sshd.client.auth.AuthenticationIdentitiesProvider;
import org.opendaylight.netconf.shaded.sshd.client.auth.BuiltinUserAuthFactories;
import org.opendaylight.netconf.shaded.sshd.client.auth.UserAuth;
import org.opendaylight.netconf.shaded.sshd.client.auth.UserAuthFactory;
import org.opendaylight.netconf.shaded.sshd.client.auth.hostbased.HostBasedAuthenticationReporter;
import org.opendaylight.netconf.shaded.sshd.client.auth.keyboard.UserInteraction;
import org.opendaylight.netconf.shaded.sshd.client.auth.password.PasswordAuthenticationReporter;
import org.opendaylight.netconf.shaded.sshd.client.auth.password.PasswordIdentityProvider;
import org.opendaylight.netconf.shaded.sshd.client.auth.pubkey.PublicKeyAuthenticationReporter;
import org.opendaylight.netconf.shaded.sshd.client.keyverifier.ServerKeyVerifier;
import org.opendaylight.netconf.shaded.sshd.client.session.ClientSession;
import org.opendaylight.netconf.shaded.sshd.common.auth.UserAuthFactoriesManager;
import org.opendaylight.netconf.shaded.sshd.common.keyprovider.KeyIdentityProviderHolder;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;

public interface ClientAuthenticationManager
extends UserAuthFactoriesManager<ClientSession, UserAuth, UserAuthFactory>,
KeyIdentityProviderHolder {
    public AuthenticationIdentitiesProvider getRegisteredIdentities();

    public PasswordIdentityProvider getPasswordIdentityProvider();

    public void setPasswordIdentityProvider(PasswordIdentityProvider var1);

    public void addPasswordIdentity(String var1);

    public String removePasswordIdentity(String var1);

    public void addPublicKeyIdentity(KeyPair var1);

    public KeyPair removePublicKeyIdentity(KeyPair var1);

    public ServerKeyVerifier getServerKeyVerifier();

    public void setServerKeyVerifier(ServerKeyVerifier var1);

    public UserInteraction getUserInteraction();

    public void setUserInteraction(UserInteraction var1);

    public PasswordAuthenticationReporter getPasswordAuthenticationReporter();

    public void setPasswordAuthenticationReporter(PasswordAuthenticationReporter var1);

    public PublicKeyAuthenticationReporter getPublicKeyAuthenticationReporter();

    public void setPublicKeyAuthenticationReporter(PublicKeyAuthenticationReporter var1);

    public HostBasedAuthenticationReporter getHostBasedAuthenticationReporter();

    public void setHostBasedAuthenticationReporter(HostBasedAuthenticationReporter var1);

    @Override
    default public void setUserAuthFactoriesNames(Collection<String> names) {
        BuiltinUserAuthFactories.ParseResult result = BuiltinUserAuthFactories.parseFactoriesList(names);
        List factories = ValidateUtils.checkNotNullAndNotEmpty(result.getParsedFactories(), "No supported user authentication factories: %s", names);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(unsupported), "Unsupported user authentication factories found: %s", unsupported);
        this.setUserAuthFactories(factories);
    }
}

