/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.client.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.netconf.shaded.sshd.client.auth.UserAuth;
import org.opendaylight.netconf.shaded.sshd.client.auth.UserAuthFactory;
import org.opendaylight.netconf.shaded.sshd.client.auth.hostbased.UserAuthHostBasedFactory;
import org.opendaylight.netconf.shaded.sshd.client.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.opendaylight.netconf.shaded.sshd.client.auth.password.UserAuthPasswordFactory;
import org.opendaylight.netconf.shaded.sshd.client.auth.pubkey.UserAuthPublicKeyFactory;
import org.opendaylight.netconf.shaded.sshd.common.Factory;
import org.opendaylight.netconf.shaded.sshd.common.NamedFactory;
import org.opendaylight.netconf.shaded.sshd.common.NamedResource;
import org.opendaylight.netconf.shaded.sshd.common.config.NamedFactoriesListParseResult;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;

public enum BuiltinUserAuthFactories implements NamedFactory<UserAuthFactory>
{
    PASSWORD(UserAuthPasswordFactory.INSTANCE),
    PUBLICKEY(UserAuthPublicKeyFactory.INSTANCE),
    KBINTERACTIVE(UserAuthKeyboardInteractiveFactory.INSTANCE),
    HOSTBASED(UserAuthHostBasedFactory.INSTANCE);

    public static final Set<BuiltinUserAuthFactories> VALUES;
    private final UserAuthFactory factory;

    private BuiltinUserAuthFactories(UserAuthFactory factory) {
        this.factory = Objects.requireNonNull(factory, "No delegate factory instance");
    }

    @Override
    public UserAuthFactory create() {
        return this.factory;
    }

    @Override
    public String getName() {
        return this.factory.getName();
    }

    public static UserAuthFactory fromFactoryName(String name) {
        Factory factory = NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
        if (factory == null) {
            return null;
        }
        return (UserAuthFactory)factory.create();
    }

    public static ParseResult parseFactoriesList(String factories) {
        return BuiltinUserAuthFactories.parseFactoriesList(GenericUtils.split(factories, ','));
    }

    public static ParseResult parseFactoriesList(String ... factories) {
        return BuiltinUserAuthFactories.parseFactoriesList(GenericUtils.isEmpty((Object[])factories) ? Collections.emptyList() : Arrays.asList(factories));
    }

    public static ParseResult parseFactoriesList(Collection<String> factories) {
        if (GenericUtils.isEmpty(factories)) {
            return ParseResult.EMPTY;
        }
        ArrayList<UserAuthFactory> resolved = new ArrayList<UserAuthFactory>(factories.size());
        List<String> unknown = Collections.emptyList();
        for (String name : factories) {
            UserAuthFactory c = BuiltinUserAuthFactories.resolveFactory(name);
            if (c != null) {
                resolved.add(c);
                continue;
            }
            if (unknown.isEmpty()) {
                unknown = new ArrayList<String>();
            }
            unknown.add(name);
        }
        return new ParseResult((List<UserAuthFactory>)resolved, unknown);
    }

    public static UserAuthFactory resolveFactory(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        return BuiltinUserAuthFactories.fromFactoryName(name);
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinUserAuthFactories.class));
    }

    public static class ParseResult
    extends NamedFactoriesListParseResult<UserAuth, UserAuthFactory> {
        public static final ParseResult EMPTY = new ParseResult(Collections.emptyList(), Collections.emptyList());

        public ParseResult(List<UserAuthFactory> parsed, List<String> unsupported) {
            super(parsed, unsupported);
        }
    }
}

