/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.client.auth.hostbased;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionContext;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;

@FunctionalInterface
public interface HostKeyIdentityProvider {
    public Iterable<? extends Map.Entry<KeyPair, List<X509Certificate>>> loadHostKeys(SessionContext var1) throws IOException, GeneralSecurityException;

    public static Iterator<? extends Map.Entry<KeyPair, List<X509Certificate>>> iteratorOf(SessionContext session, HostKeyIdentityProvider provider) throws IOException, GeneralSecurityException {
        return GenericUtils.iteratorOf(provider == null ? null : provider.loadHostKeys(session));
    }

    public static HostKeyIdentityProvider wrap(KeyPair ... pairs) {
        return HostKeyIdentityProvider.wrap(GenericUtils.asList(pairs));
    }

    public static HostKeyIdentityProvider wrap(Iterable<KeyPair> pairs) {
        return session -> GenericUtils.wrapIterable(pairs, kp -> new AbstractMap.SimpleImmutableEntry((KeyPair)kp, Collections.emptyList()));
    }
}

