/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.client.auth.pubkey;

import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.agent.SshAgent;
import org.opendaylight.netconf.shaded.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.KeyUtils;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionContext;

public class KeyAgentIdentity
implements PublicKeyIdentity {
    private final SshAgent agent;
    private final KeyPair keyPair;
    private KeyPair resolvedPair;
    private final String comment;

    public KeyAgentIdentity(SshAgent agent, PublicKey key, String comment) {
        this.agent = Objects.requireNonNull(agent, "No signing agent");
        this.keyPair = new KeyPair(Objects.requireNonNull(key, "No public key"), null);
        this.comment = comment;
    }

    @Override
    public KeyPair getKeyIdentity() {
        if (this.resolvedPair == null) {
            this.resolvedPair = this.agent.resolveLocalIdentity(this.keyPair.getPublic());
        }
        return this.resolvedPair == null ? this.keyPair : this.resolvedPair;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public Map.Entry<String, byte[]> sign(SessionContext session, String algo, byte[] data) throws Exception {
        KeyPair kp = this.getKeyIdentity();
        return this.agent.sign(session, kp.getPublic(), algo, data);
    }

    public String toString() {
        KeyPair kp = this.getKeyIdentity();
        PublicKey pubKey = kp.getPublic();
        return this.getClass().getSimpleName() + "[" + KeyUtils.getKeyType(pubKey) + "] fingerprint=" + KeyUtils.getFingerPrint(pubKey) + ", comment=" + this.getComment();
    }
}

