/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.client.auth.pubkey;

import java.io.IOException;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.agent.SshAgent;
import org.opendaylight.netconf.shaded.sshd.client.auth.pubkey.AbstractKeyPairIterator;
import org.opendaylight.netconf.shaded.sshd.client.auth.pubkey.KeyAgentIdentity;
import org.opendaylight.netconf.shaded.sshd.client.session.ClientSession;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;

public class SshAgentPublicKeyIterator
extends AbstractKeyPairIterator<KeyAgentIdentity> {
    private final SshAgent agent;
    private final Iterator<? extends Map.Entry<PublicKey, String>> keys;

    public SshAgentPublicKeyIterator(ClientSession session, SshAgent agent) throws IOException {
        super(session);
        this.agent = Objects.requireNonNull(agent, "No agent");
        this.keys = GenericUtils.iteratorOf(agent.getIdentities());
    }

    @Override
    public boolean hasNext() {
        return this.keys != null && this.keys.hasNext();
    }

    @Override
    public KeyAgentIdentity next() {
        Map.Entry<PublicKey, String> kp = this.keys.next();
        return new KeyAgentIdentity(this.agent, kp.getKey(), kp.getValue());
    }
}

