/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.client.channel;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import org.opendaylight.netconf.shaded.sshd.client.channel.PtyCapableChannelSession;
import org.opendaylight.netconf.shaded.sshd.common.channel.PtyChannelConfigurationHolder;
import org.opendaylight.netconf.shaded.sshd.common.session.Session;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.core.CoreModuleProperties;

public class ChannelExec
extends PtyCapableChannelSession {
    private final String command;
    private final byte[] cmdBytes;

    public ChannelExec(String command, PtyChannelConfigurationHolder configHolder, Map<String, ?> env) {
        this(command, StandardCharsets.UTF_8, configHolder, env);
    }

    public ChannelExec(String command, Charset charset, PtyChannelConfigurationHolder configHolder, Map<String, ?> env) {
        super(false, configHolder, env);
        this.command = ValidateUtils.checkNotNullAndNotEmpty(command, "Command may not be null/empty");
        this.cmdBytes = this.command.getBytes(charset);
    }

    public ChannelExec(byte[] command, PtyChannelConfigurationHolder configHolder, Map<String, ?> env) {
        super(false, configHolder, env);
        this.cmdBytes = ValidateUtils.checkNotNullAndNotEmpty(command, "Command may not be null/empty");
        this.command = new String(command, StandardCharsets.UTF_8);
    }

    @Override
    protected void doOpen() throws IOException {
        this.doOpenPty();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpen({}) send SSH_MSG_CHANNEL_REQUEST exec command={}", (Object)this, (Object)this.command);
        }
        Session session = this.getSession();
        boolean wantReply = CoreModuleProperties.REQUEST_EXEC_REPLY.getRequired(this);
        Buffer buffer = session.createBuffer((byte)98, this.cmdBytes.length + 32);
        buffer.putUInt(this.getRecipient());
        buffer.putString("exec");
        buffer.putBoolean(wantReply);
        buffer.putBytes(this.cmdBytes);
        this.addPendingRequest("exec", wantReply);
        this.writePacket(buffer);
        super.doOpen();
    }

    @Override
    public void handleSuccess() throws IOException {
        Date pending = this.removePendingRequest("exec");
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleSuccess({}) pending={}, command={}", new Object[]{this, pending, this.command});
        }
    }

    @Override
    public void handleFailure() throws IOException {
        Date pending = this.removePendingRequest("exec");
        if (pending != null) {
            this.log.warn("handleFailure({}) pending since={}, command={}", new Object[]{this, pending, this.command});
            this.close(true);
        }
    }
}

