/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.client.channel;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.opendaylight.netconf.shaded.sshd.client.channel.AsyncCapableClientChannel;
import org.opendaylight.netconf.shaded.sshd.common.channel.RequestHandler;
import org.opendaylight.netconf.shaded.sshd.common.session.Session;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.MapEntryUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.common.util.threads.CloseableExecutorService;

public class ChannelSession
extends AsyncCapableClientChannel {
    protected CloseableExecutorService pumperService;
    protected Future<?> pumper;
    private final Map<String, Object> env = new LinkedHashMap<String, Object>();

    public ChannelSession() {
        super("session", true);
    }

    @Override
    protected RequestHandler.Result handleInternalRequest(String req, boolean wantReply, Buffer buffer) throws IOException {
        switch (req) {
            case "xon-xoff": {
                return this.handleXonXoff(buffer, wantReply);
            }
        }
        return super.handleInternalRequest(req, wantReply, buffer);
    }

    protected RequestHandler.Result handleXonXoff(Buffer buffer, boolean wantReply) throws IOException {
        boolean clientCanDo = buffer.getBoolean();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleXonXoff({})[want-reply={}] client-can-do={}", new Object[]{this, wantReply, clientCanDo});
        }
        return RequestHandler.Result.ReplySuccess;
    }

    public Object setEnv(String key, Object value) {
        ValidateUtils.checkNotNull(key, "No key provided");
        if (value == null) {
            return this.env.remove(key);
        }
        return this.env.put(key, value);
    }

    protected void sendEnvVariables(Session session) throws IOException {
        if (MapEntryUtils.size(this.env) > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending env variables ({}) Send SSH_MSG_CHANNEL_REQUEST env: {}", (Object)this, this.env);
            }
            for (Map.Entry<String, Object> entry : this.env.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                String str = Objects.toString(value);
                Buffer buffer = session.createBuffer((byte)98, key.length() + GenericUtils.length(str) + 32);
                buffer.putInt(this.getRecipient());
                buffer.putString("env");
                buffer.putBoolean(false);
                buffer.putString(key);
                buffer.putString(str);
                this.writePacket(buffer);
            }
        }
    }
}

