/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.client.config.hosts;

import java.io.IOException;
import java.util.regex.Pattern;
import org.opendaylight.netconf.shaded.sshd.client.config.hosts.KnownHostHashValue;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;

public class HostPatternValue {
    private Pattern pattern;
    private int port;
    private boolean negated;

    public HostPatternValue() {
    }

    public HostPatternValue(Pattern pattern, boolean negated) {
        this(pattern, 0, negated);
    }

    public HostPatternValue(Pattern pattern, int port, boolean negated) {
        this.pattern = pattern;
        this.port = port;
        this.negated = negated;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    public String toString() {
        Pattern p = this.getPattern();
        String purePattern = p == null ? null : p.pattern();
        StringBuilder sb = new StringBuilder(GenericUtils.length(purePattern) + 16);
        if (this.isNegated()) {
            sb.append('!');
        }
        int portValue = this.getPort();
        try {
            KnownHostHashValue.appendHostPattern(sb, purePattern, portValue);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected (" + e.getClass().getSimpleName() + ") failure to append host pattern of " + purePattern + ":" + portValue + ": " + e.getMessage(), e);
        }
        return sb.toString();
    }
}

