/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.client.keyverifier;

import java.net.SocketAddress;
import java.security.PublicKey;
import java.util.Map;
import org.opendaylight.netconf.shaded.sshd.client.keyverifier.ServerKeyVerifier;
import org.opendaylight.netconf.shaded.sshd.client.session.ClientSession;
import org.opendaylight.netconf.shaded.sshd.common.util.logging.AbstractLoggingBean;

public class DelegatingServerKeyVerifier
extends AbstractLoggingBean
implements ServerKeyVerifier {
    @Override
    public boolean verifyServerKey(ClientSession session, SocketAddress remoteAddress, PublicKey serverKey) {
        Map<Object, Object> metadataMap = session.getMetadataMap();
        Object verifier = metadataMap.get(ServerKeyVerifier.class);
        if (verifier == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("verifyServerKey({}) No verifier found in ClientSession metadata; accepting server key", (Object)remoteAddress);
            }
            return true;
        }
        return ((ServerKeyVerifier)verifier).verifyServerKey(session, remoteAddress, serverKey);
    }
}

