/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common;

import java.util.Objects;
import java.util.function.Function;
import org.opendaylight.netconf.shaded.sshd.common.AttributeRepository;

public interface AttributeStore
extends AttributeRepository {
    default public <T> T computeAttributeIfAbsent(AttributeRepository.AttributeKey<T> key, Function<? super AttributeRepository.AttributeKey<T>, ? extends T> resolver) {
        Objects.requireNonNull(resolver, "No resolver provided");
        T value = this.getAttribute(key);
        if (value != null) {
            return value;
        }
        value = resolver.apply(key);
        if (value == null) {
            return null;
        }
        this.setAttribute(key, value);
        return value;
    }

    public <T> T setAttribute(AttributeRepository.AttributeKey<T> var1, T var2);

    public <T> T removeAttribute(AttributeRepository.AttributeKey<T> var1);

    public void clearAttributes();
}

